# User makefile to build IMAGE

# Shared options (macros) for all platforms
ZAF_ROOT=..\..
SOURCE_FILES=image.cpp

# Platform-specific options (macros)
!if "$(OPTION)" == "win16"
TARGET=wimage16.exe
TARGET_TYPE=EXE
PLATFORM=WIN16
DEFINITION_FILE=wtest16.def

!elif "$(OPTION)" == "win32"
TARGET=wimage32.exe
TARGET_TYPE=EXE
PLATFORM=WIN32

!elif "$(OPTION)" == "win32dll"
TARGET=wimage.exe
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
!endif

!ifdef OPTION
# When options defined, build using ZAF 5 make files for Borland
!include "$(ZAF_ROOT)\include\zafbor.mak"

!else
# Define options (macros) based on command-line platform
win16 win32 win32dll:
	@ECHO.
	@ECHO.
	@ECHO Making $<...
	@ECHO.
	@$(MAKE) -f borland.mak OPTION=$<
!endif
