//	Zinc Application Framework - IMAGE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- SimpleWindow -------------------------------------------------------

class SimpleWindow : public ZafWindow
{
public:
	SimpleWindow(int left, int top);
};

SimpleWindow::SimpleWindow(int left, int top) :
	ZafWindow(left, top, 40, 9)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("ImageWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Image Window")));

	ZafImage *image = new ZafImage(2, 2, 30, 5, ZAF_ITEXT("image"));
	image->SetWallpaper(true);
	Add(image);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new SimpleWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

