//	Zinc Application Framework - GROUP.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

// ----- GroupWindow --------------------------------------------------------

class GroupWindow : public ZafWindow
{
public:
	GroupWindow(int left, int top);
};

GroupWindow::GroupWindow(int left, int top) :
	ZafWindow(left, top, 60, 7)
{
	// Set the window information.
	SetSelectionType(ZAF_MULTIPLE_SELECTION);
	SetStringID(ZAF_ITEXT("GroupWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(new ZafStringData("Group Window")));

	// Add a check-box group.
	ZafGroup *group = new ZafGroup(3, 1, 25, 5, new ZafStringData("Check-box:"));
	group->SetSelectionType(ZAF_MULTIPLE_SELECTION);
	for (int i = 0; i < 8; i++)
	{
		ZafIChar string[16];
		sprintf(string, ZAF_ITEXT("Check %d"), i + 1);
		int line = i / 2;
		int column = (i % 2) * 10;
		ZafButton *button = new ZafButton(column, line, 10, 1,
			new ZafStringData(string), ZAF_NULLP(ZafBitmapData),
			ZAF_CHECK_BOX);
		button->SetAllowToggling(true);
		button->SetHzJustify(ZAF_HZ_LEFT);
		button->SetHotKey('1' + i, 6);
		group->Add(button);
	}
	Add(group);

	// Add a radio-button group.
	group = new ZafGroup(31, 1, 25, 5, new ZafStringData("Radio-button:"));
	group->SetSelectionType(ZAF_SINGLE_SELECTION);
	for (int j = 0; j < 8; j++)
	{
		ZafIChar string[16];
		sprintf(string, ZAF_ITEXT("Radio %c"), 'A' + j);
		int line = j / 2;
		int column = (j % 2) * 10;
		ZafButton *button = new ZafButton(column, line, 10, 1,
			new ZafStringData(string), ZAF_NULLP(ZafBitmapData),
			ZAF_RADIO_BUTTON);
		button->SetAllowToggling(true);
		button->SetHzJustify(ZAF_HZ_LEFT);
		button->SetHotKey('A' + j, 6);
		group->Add(button);
	}
	Add(group);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new GroupWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

