//	Zinc Application Framework - BUTTON.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>

static ZafLogicalColor bitmapArray[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};

static ZafImageStruct bitmapInfo = 
{
	16, 16, (ZafLogicalColor *)bitmapArray
};

// ----- ButtonWindow -------------------------------------------------------

class ButtonWindow : public ZafWindow
{
public:
	ButtonWindow(int left, int top);
	~ButtonWindow(void);
	static ZafEventType Beep(ZafWindowObject *, ZafEventStruct &, ZafEventType ccode);

private:
	ZafBitmapData bitmapData;
};

ButtonWindow::ButtonWindow(int left, int top) :
	ZafWindow(left, top, 40, 11),
	bitmapData(bitmapInfo)
{
	// Set the window information.
	SetSelectionType(ZAF_MULTIPLE_SELECTION);
	SetStringID(ZAF_ITEXT("ButtonWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);
	bitmapData.SetDestroyable(false);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Button Window")));

	// Create a normal button.
	ZafButton *button = new ZafButton(2, 1, 10, 1, new ZafStringData("normal"));
	Add(button);

	// Create a toggle button.
	button = new ZafButton(2, 3, 10, 1, new ZafStringData("toggle"),
		new ZafBitmapData(bitmapData));
	button->SetAllowToggling(true);
	Add(button);

	// Create a flat button.
	button = new ZafButton(2, 5, 10, 1, new ZafStringData("flat"));
	button->SetButtonType(ZAF_FLAT_BUTTON);
	button->SetBordered(true);
	Add(button);

	// Create a button that performs its action on the down-click.
	button = new ZafButton(2, 7, 10, 1, new ZafStringData("down-click"),
		new ZafBitmapData(bitmapData));
	button->SetSelectOnDownClick(true);
	Add(button);

	// Create a button that performs its action on a double-click.
	button = new ZafButton(2, 9, 10, 1, new ZafStringData("double-click"));
	button->SetSelectOnDoubleClick(true);
	Add(button);

	// Create a button that performs its action on the down-click of a double-click.
	button = new ZafButton(15, 1, 20, 1, new ZafStringData("double-down"));
	button->SetSelectOnDoubleClick(true);
	button->SetSelectOnDownClick(true);
	Add(button);

	// Create a button that performs its action repeatedly while the mouse button is down.
	button = new ZafButton(15, 3, 20, 1, new ZafStringData("repeat"),
		new ZafBitmapData(bitmapData));
	button->SetAutoRepeatSelection(true);
	Add(button);

	// Create a button that posts a message on the event manager queue using its value
	// as the event type.
	button = new ZafButton(15, 5, 20, 1, new ZafStringData("Exit (send-message)"));
	button->SetHotKey('x', 1);
	button->SetSendMessageWhenSelected(true);
	button->SetValue(L_EXIT);
	Add(button);

	// Create a disabled button.
	button = new ZafButton(15, 7, 20, 1, new ZafStringData("disabled"),
		new ZafBitmapData(bitmapData));
	button->SetDisabled(true);
	Add(button);

	// Create a default button.
	button = new ZafButton(15, 9, 20, 1, new ZafStringData("Beep (default)"),
		new ZafBitmapData(bitmapData));
	Add(button);
	button->SetHotKey('B', 0);
	button->SetAllowDefault(true);
	button->SetUserFunction(Beep);
	SetDefaultButton(button, true);
}

ButtonWindow::~ButtonWindow(void)
{
	// We must specifically destroy the window's children before the static
	// iconData is destroyed (The natural call sequence order of destruction
	// is wrong).
	ZafList::Destroy();
}

ZafEventType ButtonWindow::Beep(ZafWindowObject *, ZafEventStruct &, ZafEventType ccode)
{
	// Check for a select message.
	if (ccode == L_SELECT)
		ZafErrorSystem::Beep();
	return (0);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new ButtonWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

