//	Zinc Application Framework - C_STORED.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_STORED_HPP)
#	define C_STORED_HPP
#	include "c_storew.hpp"

// --------------------------------------------------------------------------
// ----- ZafDeltaStorageObject ----------------------------------------------
// --------------------------------------------------------------------------

class ZafBitVector
{
public:
	// --- General members ---
	ZafBitVector(ZafUInt16 _size=0);
	ZafBitVector(ZafBufferObject *object);
	virtual ~ZafBitVector();
	void Clear(ZafUInt16 pos);
	void Set(ZafUInt16 pos);
	int Test(ZafUInt16 pos, int _default = false);

	void Write(ZafBufferObject *object);

private:
	ZafUInt8 *vector;
	ZafUInt16 size;
};

class ZafDeltaStorageObjectReadOnly : public OldStorageObjectReadOnly
{
public:
	// --- General members ---
	ZafDeltaStorageObjectReadOnly(ZafBufferObject *object,
		OldStorageReadOnly &file, const ZafIChar *name,
		ZafClassID classID);
	virtual ~ZafDeltaStorageObjectReadOnly(void);

	int Read(ZafInt16 &value);
	int Read(ZafUInt16 &value);
	int Read(ZafInt32 &value);
	int Read(ZafUInt32 &value);
	int Read(ZafUInt8 &value);
	int Read(ZafInt8 &value);
	int Read(void *buff, int size, int length);
	int Read(ZafIChar *string, int length);
	int Read(ZafIChar **string);

private:
	ZafBufferObject *object;
	ZafBitVector *bools;
	ZafUInt16 current;
};

class ZafDeltaStorageObject : public OldStorageObject
{
public:
	// --- General members ---
	ZafDeltaStorageObject(ZafBufferObject *_object,
		OldStorage &file, const ZafIChar *name,
		ZafClassID classID, ZafFileMode mode = ZAF_FILE_READWRITE);
	virtual ~ZafDeltaStorageObject(void);

	int Write(ZafInt16 value);
	int Write(ZafUInt16 value);
	int Write(ZafInt32 value);
	int Write(ZafUInt32 value);
	int Write(ZafInt8 value);
	int Write(ZafUInt8 value);
	int Write(void *buff, int size, int length);
	int Write(const ZafIChar *string);

private:
	ZafBufferObject *object;
	ZafBitVector *bools;
	ZafUInt16 current;
	int Write(const OldDirectoryEntry *dirent);
};

#endif // C_STORED_HPP

