//	Zinc Application Framework - C_STORE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_STORE_HPP)
#	define C_STORE_HPP
# 	include <z_list.hpp>
# 	include "c_file.hpp"
# 	include "c_direct.hpp"

// ----- Private class & const declarations ---------------------------------
typedef ZafUInt16 ZafDiskAddress; // Private type declaration.
typedef ZafUInt32 ZafINodeNumber; // Private type declaration.

const int BYTES_PER_DATA_BLOCK_4X = 256;
const int DISK_ADDR_PER_DATA_BLOCK_4X = (BYTES_PER_DATA_BLOCK_4X / sizeof(ZafDiskAddress));
const int BYTES_PER_BLOCK_4X = BYTES_PER_DATA_BLOCK_4X;
const int COPY_BYTES = 4096;

const int ZAF_IREAD 						= 0;
const int ZAF_IWRITE 						= 1;

const int BYTES_PER_DATA_BLOCK = 64;
//const int DISK_ADDR_PER_DATA_BLOCK = (BYTES_PER_DATA_BLOCK / sizeof(ZafDiskAddress));
const int BYTES_PER_BLOCK = BYTES_PER_DATA_BLOCK;
const ZafUInt16 ZAF_MAGIC_NUMBER = 0x05AF;

#if defined(ZAF_UNICODE)
	const ZafUInt8 ZAF_MAJOR_FILE_VERSION = 5; //New version
//	const ZafUInt8 ZAF_MAJOR_FILE_VERSION = 4;
	const ZafUInt8 ZAF_MINOR_FILE_VERSION = 5;
#else
	const ZafUInt8 ZAF_MAJOR_FILE_VERSION = 5; // New version
//	const ZafUInt8 ZAF_MAJOR_FILE_VERSION = 4;
	const ZafUInt8 ZAF_MINOR_FILE_VERSION = 0;
#endif

// --------------------------------------------------------------------------
// ----- ZafBufferObject --------------------------------------------------
// --------------------------------------------------------------------------

class ZafBufferObject : public OldFile
{
	friend class OldStorageDirectory;
public:
	// --- General members ---
	ZafBufferObject(int blocks = 1);
	virtual ~ZafBufferObject(void);
	long GetLength(void) const;
	ZafError Rename(const ZafIChar *pathName);
	ZafError Seek(ZafOffset offset, ZafSeek location);
	ZafOffset Tell(void) const;

	// --- Read functions ---
	virtual int Read(ZafInt8 &value);
	virtual int Read(ZafUInt8 &value);
	virtual int Read(ZafInt16 &value);
	virtual int Read(ZafUInt16 &value);
#if (ZAF_WORD_SIZE != 64)
	virtual int Read(int &value);
#endif
	virtual int Read(ZafInt32 &value);
	virtual int Read(ZafUInt32 &value);
	virtual int Read(double &value);
	virtual int Read(ZafIChar *text, int length);
	virtual int Read(ZafIChar **text);
	virtual int Read(void *buffer, int size, int length);

	// --- Write functions ---
	virtual int Write(ZafInt8 value);
	virtual int Write(ZafUInt8 value);
	virtual int Write(ZafInt16 value);
	virtual int Write(ZafUInt16 value);
#if (ZAF_WORD_SIZE != 64)
	virtual int Write(int value);
#endif
	virtual int Write(ZafInt32 value);
	virtual int Write(ZafUInt32 value);
	virtual int Write(double value);
	virtual int Write(const ZafIChar *text);
	virtual int Write(void *buffer, int size, int length);

protected:
	enum ZafDirection
	{
		ZAF_IREAD,
		ZAF_IWRITE
	};

	ZafInt32 position;
	ZafInt32 length;
	ZafInt32 size;
	char *buffer;

	int TransferData(void *data, unsigned N, ZafDirection direction);
};

#endif // ZAF_STORE_HPP

