//	Zinc Application Framework - C_PATH.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_PATH_HPP)
#	define C_PATH_HPP
#	include <z_list.hpp>

#define ZAF_PATHSEP ';'

// --------------------------------------------------------------------------
// ----- ZafPathElement & ZafPath -------------------------------------------
// --------------------------------------------------------------------------

//class ZAF_EXPORT ZafPathElement : public ZafElement
class ZafPathElement : public ZafElement
{
public:
	// --- General members ---
	ZafIChar *pathName;

	ZafPathElement(const ZafIChar *pathName, int length = -1);
	virtual ~ZafPathElement(void);

	// --- Element members ---
	ZafPathElement *Next(void) const { return((ZafPathElement *)next); }
	ZafPathElement *Previous(void) const { return((ZafPathElement *)previous); }
};

//class ZAF_EXPORT ZafPath : public ZafList
class ZafPath : public ZafList
{
public:
	static ZafIChar *pathString;
	static ZafIChar *zincPathString;

	// --- General members ---
	ZafPath(const ZafIChar *programPath = ZAF_NULLP(ZafIChar), int rememberCWD = true);
	ZafPath(const ZafIChar *fragment1, const ZafIChar *fragment2, ...);
	ZafPath(const ZafPath &copy);
	virtual ~ZafPath(void);
	const ZafIChar *FirstPathName(void)
		{ current = first; return (current ? (const ZafIChar *)Current()->pathName : ZAF_NULLP(const ZafIChar)); }
	const ZafIChar *NextPathName(void)
		{ current = current ? Current()->Next() : ZAF_NULLP(ZafElement);
		  return (current ? Current()->pathName : ZAF_NULLP(const ZafIChar)); }

	// --- List members ---
	ZafPathElement *Current(void) const { return((ZafPathElement *)current); }
	ZafPathElement *First(void) const { return((ZafPathElement *)first); }
	ZafPathElement *Last(void) const { return((ZafPathElement *)last); }

private:
	void LoadPath(const ZafIChar *envName);
};

//extern ZAF_EXPORT ZafPath *zafSearchPath;
extern ZafPath *zafSearchPath;

#endif // C_PATH_HPP

