//	Zinc Application Framework - C_PATH.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "c_path.hpp"
#include <z_cset.hpp>
#if (!defined(sun) && !defined(__sgi) && !defined(SCO_UNIX)) || defined(ZAF_UNICODE)
#	include <z_unistd.hpp>
#endif
#include <z_stdlib.hpp>
#include <z_string.hpp>
#include <z_stdarg.hpp>
#if defined(ZAF_MOTIF) && defined(__DVX__)
#	include <direct.h>
#endif

// ----- ZafPathElement ---------------------------------------------------

ZafPathElement::ZafPathElement(const ZafIChar *_pathName, int length)
{
	if (length == -1)
		length = strlen(_pathName);
	pathName = new ZafIChar[length+1];
	strncpy(pathName, _pathName, length);
	pathName[length] = '\0';
}

ZafPathElement::~ZafPathElement(void)
{
	delete []pathName;
}

// ----- ZafPath -----------------------------------------------------------

static ZafIChar ZAF_FARDATA __pathString[]	= { 'P','A','T','H', 0 };
static ZafIChar ZAF_FARDATA __zincPathString[]	= { 'Z','I','N','C','_','P','A','T','H', 0 };

ZafIChar *ZafPath::pathString = __pathString;
ZafIChar *ZafPath::zincPathString = __zincPathString;

ZafPath *zafSearchPath = ZAF_NULLP(ZafPath);

ZafPath::ZafPath(const ZafIChar *programPath, int rememberCWD)
{
	// Get the path names.
#if defined(ZAF_MACINTOSH)
	// The Macintosh library does not change folders, so the current folder is always searched.
#	pragma unused(rememberCWD)
#else
	if (rememberCWD)				// The current working directory.
	{
		ZafIChar pathName[256];
		getcwd(pathName, sizeof(pathName)/sizeof(pathName[0]));
		Add(new ZafPathElement(pathName));
	}
#endif

	if (programPath)				// The program path.
	{
		ZafIChar pathName[256];
		strcpy(pathName, programPath);
		ZafIChar *endPath = strrchr(pathName, zafCodeSet->dirSepStr[0]);
		if (endPath)
		{
#if defined(ZAF_MSDOS) || defined(ZAF_MSWINDOWS) || defined(ZAF_OS2)
			if (endPath > pathName && *(endPath - 1) == ':')
				endPath++;			// Leave in the slash if root dir.
#endif
			*endPath = '\0';
		}
		Add(new ZafPathElement(pathName));
	}
	LoadPath(zincPathString);
	LoadPath(pathString);
}

ZafPath::ZafPath(const ZafIChar *fragment1, const ZafIChar *fragment2, ...)
{
	Add(new ZafPathElement(fragment1));
	if (fragment2)
	{
		Add(new ZafPathElement(fragment2));
		va_list args;
		va_start(args, fragment2);
		const ZafIChar *fragment;
		while ((fragment = va_arg(args, const ZafIChar *)) != 0)
			Add(new ZafPathElement(fragment));
	}
}

ZafPath::~ZafPath(void)
{
}

#if defined(ZAF_MACINTOSH)
void ZafPath::LoadPath(const ZafIChar *)
{
	// The MacOS does not provide an environment variable facility.
}
#else
void ZafPath::LoadPath(const ZafIChar *envname)
{
	ZafIChar *path = getenv(envname);
	if (path)
	{
		for (int i = 0; path[i]; )	// Parse the directory tree.
		{
			int j;
			for (j = i; path[j] && path[j] != ZAF_PATHSEP; )
				j++;
			Add(new ZafPathElement(&path[i], j - i));
			i = path[j] ? j + 1 : j;
		}
	}
}
#endif
