//	Zinc Application Framework - C_FILE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_FILE_HPP)
#	define C_FILE_HPP
#	include <z_file.hpp>
#	include <z_store.hpp>
#	include <z_env.hpp>
#	include <z_stdio.hpp>
#	include <z_unistd.hpp>

// --------------------------------------------------------------------------
// ----- OldFile ------------------------------------------------------------
// --------------------------------------------------------------------------

const ZafUInt16 ZAF_DIRECTORY_TAG 			= 0x8000;

class OldFile
{
public:
	// --- General members ---
	OldFile(const ZafIChar *pathName, ZafFileMode mode);
	virtual ~OldFile(void);
	bool Destroyable(void) const;
	ZafError Error(void) const;
	ZafOffset GetLength(void) const;
	ZafError Rename(const ZafIChar *pathName);
	virtual ZafError Seek(ZafOffset offset, ZafSeek location);
	ZafError SetError(ZafError error);
	ZafVersion SetVersion(ZafVersion version);
	virtual ZafOffset Tell(void) const;
	ZafVersion Version(void) const;

	// --- Modes ---
	// get
	bool BinaryMode(void) const;
	bool Copy(void) const;
	bool Create(void) const;
	bool DerivedAccess(void) const;
	bool OpenCreate(void) const;
	bool ReadOnly(void) const;
	bool ReadWrite(void) const;
	bool Temporary(void) const;
	bool TextMode(void) const;

	// --- Read functions ---
	virtual int Read(ZafInt8 &value);
	virtual int Read(ZafUInt8 &value);
	virtual int Read(ZafInt16 &value);
	virtual int Read(ZafUInt16 &value);
#if ZAF_WORD_SIZE != 64
	virtual int Read(int &value);
#endif
	virtual int Read(ZafInt32 &value);
	virtual int Read(ZafUInt32 &value);
	virtual int Read(double &value);
	virtual int Read(ZafIChar *text, int length);
	virtual int Read(ZafIChar **text);
	virtual int Read(void *buffer, int size, int num);

	// --- Write functions ---
	virtual int Write(ZafInt8 value);
	virtual int Write(ZafUInt8 value);
	virtual int Write(ZafInt16 value);
	virtual int Write(ZafUInt16 value);
#if ZAF_WORD_SIZE != 64
	virtual int Write(int value);
#endif
	virtual int Write(ZafInt32 value);
	virtual int Write(ZafUInt32 value);
	virtual int Write(double value);
	virtual int Write(const ZafIChar *text);
	virtual int Write(void *buffer, int size, int num);

	// --- Operator overloads ---
	OldFile &operator>>(ZafInt8 &value) { Read(value); return (*this); }
	OldFile &operator>>(ZafUInt8 &value) { Read(value); return (*this); }
	OldFile &operator>>(ZafInt16 &value) { Read(value); return (*this); }
	OldFile &operator>>(ZafUInt16 &value) { Read(value); return (*this); }
#if ZAF_WORD_SIZE != 64
	OldFile &operator>>(int &value) { Read(value); return (*this); }
#endif
	OldFile &operator>>(ZafInt32 &value) { Read(value); return (*this); }
	OldFile &operator>>(ZafUInt32 &value) { Read(value); return (*this); }
	OldFile &operator>>(double &value) { Read(value); return (*this); }
	OldFile &operator>>(ZafIChar *text) { Read(text, -1); return (*this); }
	OldFile &operator>>(ZafIChar **text) { Read(text); return (*this); }

	OldFile &operator<<(ZafInt8 value) { Write(value); return (*this); }
	OldFile &operator<<(ZafUInt8 value) { Write(value); return (*this); }
	OldFile &operator<<(ZafInt16 value) { Write(value); return (*this); }
	OldFile &operator<<(ZafUInt16 value) { Write(value); return (*this); }
#if ZAF_WORD_SIZE != 64
	OldFile &operator<<(int value) { Write(value); return (*this); }
#endif
	OldFile &operator<<(ZafInt32 value) { Write(value); return (*this); }
	OldFile &operator<<(ZafUInt32 value) { Write(value); return (*this); }
	OldFile &operator<<(double value) { Write(value); return (*this); }
	OldFile &operator<<(const ZafIChar *text) { Write(text); return (*this); }

#if defined(ZAF_MACINTOSH)
	static OSType fileCreator;
	static OSType fileType;
#endif

protected:
	// --- General class members ---
	ZafError error;
	ZafFileMode mode;
	int useCount;
	ZafVersion version;

	ZafIChar *pathName;
#	if defined(ZAF_MACINTOSH)
	short file;
#	else
	FILE *file;
#	endif
};

// --- inline functions ---
inline bool OldFile::BinaryMode(void) const { return (mode & ZAF_FILE_BINARY); }
inline bool OldFile::Copy(void) const { return (mode & ZAF_FILE_COPY); }
inline bool OldFile::Create(void) const { return (mode & ZAF_FILE_CREATE); }
inline bool OldFile::Destroyable(void) const { return (useCount ? false : true); }
inline bool OldFile::DerivedAccess(void) const { return (mode & ZAF_FILE_DERIVED_ACCESS); }
inline ZafError OldFile::Error(void) const { return (error); }
inline bool OldFile::OpenCreate(void) const { return (mode & ZAF_FILE_OPENCREATE); }
inline bool OldFile::ReadOnly(void) const { return (mode & ZAF_FILE_READ); }
inline bool OldFile::ReadWrite(void) const { return (mode & ZAF_FILE_READWRITE); }
inline bool OldFile::Temporary(void) const { return (mode & ZAF_FILE_TEMPORARY); }
inline bool OldFile::TextMode(void) const { return (mode & ZAF_FILE_TEXT); }
inline ZafVersion OldFile::Version(void) const { return (version); }

#endif // ZAF_FILE_HPP

