//	Zinc Application Framework - CONVERT2.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "convert1.hpp"

// Note that CONVERT2.CPP and CONVERT3.CPP must be separate files, since
// the compilers run out of memory otherwise.

// ----- ZafConvertWindow ---------------------------------------------------

ZafConvertWindow::ZafConvertStruct ZAF_FARDATA ZafConvertWindow::convert[] =
{
	{ ID_ZAF_BIGNUM,			Read_BIGNUM },
	{ ID_ZAF_BORDER,			Read_BORDER },
	{ ID_ZAF_BUTTON,			Read_BUTTON },
	{ ID_ZAF_COMBO_BOX,			Read_COMBO_BOX },
	{ ID_ZAF_DATE,				Read_DATE },
	{ ID_ZAF_FORMATTED_STRING,	Read_FORMATTED_STRING },
	{ ID_ZAF_GROUP,				Read_GROUP },
	{ ID_ZAF_HZ_LIST,			Read_HZ_LIST },
	{ ID_ZAF_ICON,				Read_ICON },
	{ ID_ZAF_INTEGER,			Read_INTEGER },
	{ ID_ZAF_MAXIMIZE_BUTTON,	Read_MAXIMIZE_BUTTON },
	{ ID_ZAF_MINIMIZE_BUTTON,	Read_MINIMIZE_BUTTON },
	{ ID_ZAF_NOTEBOOK,			Read_NOTEBOOK },
	{ ID_ZAF_POP_UP_MENU,		Read_POP_UP_MENU },
	{ ID_ZAF_POP_UP_ITEM,		Read_POP_UP_ITEM },
	{ ID_ZAF_PROMPT,			Read_PROMPT },
	{ ID_ZAF_PULL_DOWN_MENU,	Read_PULL_DOWN_MENU },
	{ ID_ZAF_PULL_DOWN_ITEM,	Read_PULL_DOWN_ITEM },
	{ ID_ZAF_REAL,				Read_REAL },
	{ ID_ZAF_SCROLL_BAR,		Read_SCROLL_BAR },
	{ ID_ZAF_SPIN_CONTROL,		Read_SPIN_CONTROL },
	{ ID_ZAF_STATUS_BAR,		Read_STATUS_BAR },
	{ ID_ZAF_STRING,			Read_STRING },
	{ ID_ZAF_SYSTEM_BUTTON,		Read_SYSTEM_BUTTON },
	{ ID_ZAF_TABLE,				Read_TABLE },
	{ ID_ZAF_TABLE_HEADER,		Read_TABLE_HEADER },
	{ ID_ZAF_TABLE_RECORD,		Read_TABLE_RECORD },
	{ ID_ZAF_TEXT,				Read_TEXT },
	{ ID_ZAF_TIME,				Read_TIME },
	{ ID_ZAF_TITLE,				Read_TITLE },
	{ ID_ZAF_TOOL_BAR,			Read_TOOL_BAR },
	{ ID_ZAF_VT_LIST,			Read_VT_LIST },
	{ ID_ZAF_WINDOW,			Read_WINDOW },
	{ ID_ZAF_GEOMETRY_MANAGER,	Read_GEOMETRY_MANAGER },
	{ ID_END,					0 }
};

ZafConvertWindow::ZafConvertGeometryStruct ZAF_FARDATA ZafConvertWindow::convertGeometry[] =
{
	{ ID_ZAF_CONSTRAINT,		Read_CONSTRAINT },
	{ ID_ZAF_ATTACHMENT,		Read_ATTACHMENT },
	{ ID_ZAF_RELATIVE_CONSTRAINT,		Read_RELATIVE_CONSTRAINT },
	{ ID_ZAF_DIMENSION_CONSTRAINT,	Read_DIMENSION_CONSTRAINT },
	{ ID_END,					0 }
};

ZafConvertWindow::ZafConvertDerivedStruct ZAF_FARDATA ZafConvertWindow::convertDerived[] =
{
	{ ID_ZAF_BIGNUM,			ReadDerivedBignum },
//	{ ID_ZAF_BORDER,			ReadDerivedBorder },
	{ ID_ZAF_BUTTON,			ReadDerivedButton },
	{ ID_ZAF_COMBO_BOX,			ReadDerivedComboBox },
	{ ID_ZAF_DATE,				ReadDerivedDate },
	{ ID_ZAF_FORMATTED_STRING,	ReadDerivedFormattedString },
	{ ID_ZAF_GROUP,				ReadDerivedGroup },
	{ ID_ZAF_HZ_LIST,			ReadDerivedHzList },
	{ ID_ZAF_ICON,				ReadDerivedIcon },
	{ ID_ZAF_INTEGER,			ReadDerivedInteger },
	{ ID_ZAF_MAXIMIZE_BUTTON,	ReadDerivedMaximizeButton },
	{ ID_ZAF_MINIMIZE_BUTTON,	ReadDerivedMinimizeButton },
	{ ID_ZAF_NOTEBOOK,			ReadDerivedNotebook },
	{ ID_ZAF_POP_UP_MENU,		ReadDerivedPopUpMenu },
	{ ID_ZAF_POP_UP_ITEM,		ReadDerivedPopUpItem },
	{ ID_ZAF_PROMPT,			ReadDerivedPrompt },
	{ ID_ZAF_PULL_DOWN_MENU,	ReadDerivedPullDownMenu },
	{ ID_ZAF_PULL_DOWN_ITEM,	ReadDerivedPullDownItem },
	{ ID_ZAF_REAL,				ReadDerivedReal },
	{ ID_ZAF_SCROLL_BAR,		ReadDerivedScrollBar },
	{ ID_ZAF_SPIN_CONTROL,		ReadDerivedSpinControl },
	{ ID_ZAF_STATUS_BAR,		ReadDerivedStatusBar },
	{ ID_ZAF_STRING,			ReadDerivedString },
	{ ID_ZAF_SYSTEM_BUTTON,		ReadDerivedSystemButton },
	{ ID_ZAF_TABLE,				ReadDerivedTable },
	{ ID_ZAF_TABLE_HEADER,		ReadDerivedTableHeader },
	{ ID_ZAF_TABLE_RECORD,		ReadDerivedTableRecord },
	{ ID_ZAF_TEXT,				ReadDerivedText },
	{ ID_ZAF_TIME,				ReadDerivedTime },
	{ ID_ZAF_TITLE,				ReadDerivedTitle },
	{ ID_ZAF_TOOL_BAR,			ReadDerivedToolBar },
	{ ID_ZAF_VT_LIST,			ReadDerivedVtList },
	{ ID_ZAF_WINDOW,			ReadDerivedWindow },
	{ ID_ZAF_WINDOW_OBJECT,			ReadDerivedWindowObject },
	{ ID_END,					0 }
};

ZafWindowObject *ZafConvertWindow::ReadDerivedBignum(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedBignum(saveID);
	Read_BIGNUM(object, directory, file, persist);
	return (object);
}

ZafWindowObject *ZafConvertWindow::ReadDerivedButton(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedButton(saveID);
	Read_BUTTON(object, directory, file, persist);
	return (object);
}

ZafWindowObject *ZafConvertWindow::ReadDerivedComboBox(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedComboBox(saveID);
	Read_COMBO_BOX(object, directory, file, persist);
	return (object);
}

ZafWindowObject *ZafConvertWindow::ReadDerivedDate(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedDate(saveID);
	Read_DATE(object, directory, file, persist);
	return (object);
}

ZafWindowObject *ZafConvertWindow::ReadDerivedFormattedString(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedFormattedString(saveID);
	Read_FORMATTED_STRING(object, directory, file, persist);
	return (object);
}

ZafWindowObject *ZafConvertWindow::ReadDerivedGroup(ZafClassID saveID,
	OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist)
{
	ZafWindowObject *object = new ZafDerivedGroup(saveID);
	Read_GROUP(object, directory, file, persist);
	return (object);
}


