//	Zinc Application Framework - W_TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define USE_RAW_KEYS
#include "w_app.hpp"
#include <z_keymap.hpp>
#include <z_table.hpp>

// ----- OS Specific Functions ----------------------------------------------

void ZafTable::OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state)
{
	// Get default colors from the operating system.
	if (type == ZAF_PM_TEXT || type == ZAF_PM_FOREGROUND)
	{
		if (palette.colorForeground == ZAF_CLR_DEFAULT && palette.osPalette.colorForeground == 0xFFFFFFFFL)
		{
			if (state & ZAF_PM_SELECTED)
				palette.osPalette.colorForeground = GetSysColor(COLOR_HIGHLIGHTTEXT);
			else
				palette.osPalette.colorForeground = GetSysColor(COLOR_WINDOWTEXT);
		}
		if (palette.colorBackground == ZAF_CLR_DEFAULT && palette.osPalette.colorBackground == 0xFFFFFFFFL)
		{
			if (state & ZAF_PM_SELECTED)
				palette.osPalette.colorBackground = GetSysColor(COLOR_HIGHLIGHT);
			else
				palette.osPalette.colorBackground = GetSysColor(COLOR_WINDOW);
		}
	}
	else if (type == ZAF_PM_BACKGROUND)
	{
		if (palette.colorForeground == ZAF_CLR_DEFAULT && palette.osPalette.colorForeground == 0xFFFFFFFFL)
		{
			if (state & ZAF_PM_SELECTED)
				palette.osPalette.colorForeground = GetSysColor(COLOR_HIGHLIGHT);
			else
				palette.osPalette.colorForeground = GetSysColor(COLOR_WINDOW);
		}
		if (palette.colorBackground == ZAF_CLR_DEFAULT && palette.osPalette.colorBackground == 0xFFFFFFFFL)
		{
			if (state & ZAF_PM_SELECTED)
				palette.osPalette.colorBackground = GetSysColor(COLOR_HIGHLIGHT);
			else
				palette.osPalette.colorBackground = GetSysColor(COLOR_WINDOW);
		}
	}
	else if (type == ZAF_PM_OUTLINE)
	{
		if (state & ZAF_PM_CURRENT)
			palette.osPalette.colorForeground = palette.osPalette.colorBackground = GetSysColor(COLOR_WINDOWTEXT);
		else
			palette.osPalette.colorForeground = palette.osPalette.colorBackground = GetSysColor(COLOR_3DFACE);
	}
	else if (type == ZAF_PM_DARK_SHADOW)
		palette.osPalette.colorForeground = palette.osPalette.colorBackground = GetSysColor(COLOR_3DFACE);
	else
		ZafWindow::OSMapPalette(palette, type, state);
}

void ZafTable::OSRegisterObject(void)
{
	// Defer to the base window class.
	ZafWindow::OSRegisterObject();
}

OSWindowID ZafTable::OSScreenID(ZafScreenIDType type) const
{
	// Determine the proper widget.
	return (ZafWindow::OSScreenID(type));
}

