//	Zinc Application Framework - W_SYS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_sys.hpp>

// ----- ZafSystemButton --------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafSystemButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0 }
};

ZafWindowObject *ZafSystemButton::Add(ZafWindowObject *object, ZafWindowObject *position)
{
	// Add the item to the menu.
	return (menu.Add(object, position));
}

ZafEventType ZafSystemButton::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	return ccode;
}

ZafEventType ZafSystemButton::Event(const ZafEventStruct &event)
{
	// Switch on the event type.
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_REGISTER_OBJECT:
		screenID = parent->OSScreenID(ZAF_FRAMEID);

		if (SystemButtonType() != ZAF_NATIVE_SYSTEM_BUTTON)
		{
			// Get a copy of the system menu.
			menu.screenID = (HWND)GetSystemMenu(parent->OSScreenID(ZAF_FRAMEID), FALSE);

			// Remove all system menu items because they will be added manually.
			while (DeleteMenu((HMENU)menu.screenID, 0, MF_BYPOSITION))
				;
		}

		if (SystemButtonType() != ZAF_NATIVE_SYSTEM_BUTTON)
			menu.Event(event);
		break;

	case S_DEINITIALIZE:
		// Reset the system menu.
		if (SystemButtonType() != ZAF_NATIVE_SYSTEM_BUTTON)
			GetSystemMenu(parent->OSScreenID(ZAF_FRAMEID), TRUE);
		screenID = 0;
		break;

	default:
		ccode = S_UNKNOWN;
		break;
	}

	// Return the control code.
	return (ccode);
}

ZafSystemButtonType ZafSystemButton::SetSystemButtonType(ZafSystemButtonType setSystemButtonType)
{
	// Make sure the request is valid.
	if (systemButtonType != setSystemButtonType && !screenID)
		systemButtonType = setSystemButtonType;
	return (systemButtonType);
}

ZafWindowObject *ZafSystemButton::Subtract(ZafWindowObject *object)
{
	return (menu.Subtract(object));
}

// ----- OS Specific Functions ----------------------------------------------

// ----- Stubs --------------------------------------------------------------

void ZafSystemButton::OSRegisterObject(void)
{
}

void ZafSystemButton::OSSize(void)
{
}

ZafError ZafSystemButton::OSUpdatePalettes(ZafPaletteType, ZafPaletteType)
{
	return (ZAF_ERROR_NONE);
}
