//	Zinc Application Framework - M_SCLWIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_sclwin.hpp>
#include <z_utils.hpp>

// ----- ZafScrolledWindow ------------------------------------------------

ZafEventMap ZAF_FARDATA ZafScrolledWindow::defaultEventMap[] =
{
	{ L_NONE, 	0, 		0, 			0 }
};

ZafPositionStruct ZafScrolledWindow::ConvertToOSPosition(const ZafWindowObject *object,
	const ZafPositionStruct *zafPosition) const
{
	return ZafWindow::ConvertToOSPosition(object, zafPosition);
}

ZafPositionStruct ZafScrolledWindow::ConvertToZafPosition(const ZafWindowObject *object,
	const ZafPositionStruct *osPosition) const
{
	return ZafWindow::ConvertToZafPosition(object, osPosition);
}

ZafEventType ZafScrolledWindow::Event(const ZafEventStruct &event)
{
	// Check for zinc events.
	ZafEventType ccode = event.type;

	if (ccode == E_OSEVENT)
		return ZafWindow::OSEvent(event);

	switch (ccode)
	{
	case S_INITIALIZE:
		ConvertRegion(scrollRegion, ZAF_PIXEL);
		ccode = ZafWindow::Event(event);
		break;

	// ----- Position & Size messages -----
	case N_SIZE:
		// Defer to the base class.
		ccode = ZafWindow::Event(event);

		// Adjust the scroll bar information.
		Event(S_HSCROLL_COMPUTE);
		Event(S_VSCROLL_COMPUTE);

		// Adjust the scroll region.
		if (scrollRegion.left < 0 && scrollRegion.right < clientRegion.Width() - 1)
		{
			ZafEventStruct scrollEvent(S_HSCROLL);
			scrollEvent.scroll.delta = -ZafMin(-scrollRegion.left, clientRegion.Width() - scrollRegion.right - 1);
			Event(scrollEvent);
		}

		if (scrollRegion.top < 0 && scrollRegion.bottom < clientRegion.Height() - 1)
		{
			ZafEventStruct scrollEvent(S_VSCROLL);
			scrollEvent.scroll.delta = -ZafMin(-scrollRegion.top, clientRegion.Height() - scrollRegion.bottom - 1);
			Event(scrollEvent);
		}
		break;

	case S_HSCROLL:
	case N_HSCROLL:
		{
		ZafScrollBar *hzScrollBar = HorizontalScrollBar();
		int delta = (int)event.scroll.delta;
		scrollRegion.left -= delta;
		scrollRegion.right -= delta;
		ScrollWindow(screenID, (int)-delta, 0, NULL, NULL);
		UpdateWindow(screenID);
		if (ccode == S_HSCROLL && hzScrollBar)
		{
			ZafScrollData hScroll = *hzScrollBar->ScrollData();
			hScroll.current += delta;
			hzScrollBar->ScrollData()->SetScroll(hScroll);
		}
		}
		break;

	case S_VSCROLL:
	case N_VSCROLL:
		{
		ZafScrollBar *vtScrollBar = VerticalScrollBar();
		int delta = (int)event.scroll.delta;
		scrollRegion.top -= delta;
		scrollRegion.bottom -= delta;
		ScrollWindow(screenID, 0, (int)-delta, NULL, NULL);
		UpdateWindow(screenID);
		if (ccode == S_VSCROLL && vtScrollBar)
		{
			ZafScrollData vScroll = *vtScrollBar->ScrollData();
			vScroll.current += delta;
			vtScrollBar->ScrollData()->SetScroll(vScroll);
		}
		}
		break;

	case S_VSCROLL_CHECK:
	case S_HSCROLL_CHECK:
		// Check the current object to ensure it is currently visible within
		// the window.  If not, scroll the window so the object appears on 
		// the screen.
//??? Not implemented yet!
		break;

	case S_VSCROLL_COMPUTE:
		{
		ZafScrollBar *vtScrollBar = VerticalScrollBar();
		if (vtScrollBar)
		{
			ZafScrollStruct vScroll;
			vScroll.minimum = 0;
			vScroll.maximum = scrollRegion.Height() - clientRegion.Height();
			vScroll.showing = clientRegion.Height();
			vScroll.current = -scrollRegion.top;
			vScroll.delta = display->cellHeight;

			if (vScroll.maximum < 0)
				vScroll.maximum = 0;
			vtScrollBar->ScrollData()->SetScroll(vScroll);
		}
		}
		break;

	case S_HSCROLL_COMPUTE:
		{
		ZafScrollBar *hzScrollBar = HorizontalScrollBar();
		if (hzScrollBar)
		{
			ZafScrollStruct hScroll;
			hScroll.minimum = 0;
			hScroll.maximum = scrollRegion.Width() - clientRegion.Width();
			hScroll.showing = clientRegion.Width();
			hScroll.current = -scrollRegion.left;
			hScroll.delta = display->cellWidth;

			if (hScroll.maximum < 0)
				hScroll.maximum = 0;
			hzScrollBar->ScrollData()->SetScroll(hScroll);
		}
		}
		break;

	default:
		// Defer to the base class.
		ccode = ZafWindow::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}


// ----- OS Specific Functions ----------------------------------------------

void ZafScrolledWindow::OSRegisterObject(void)
{
	ZafWindow::OSRegisterObject();
}

// ----- Stubs --------------------------------------------------------------

void ZafScrolledWindow::GetClip(ZafWindowObject *, ZafRegionStruct &, ZafRegionStruct &)
{
}

OSWindowID ZafScrolledWindow::OSScreenID(ZafScreenIDType type) const
{
	return ZafWindow::OSScreenID(type);
}

ZafEventType ZafScrolledWindow::OSEvent(const ZafEventStruct &event)
{
	return ZafWindow::OSEvent(event);
}

ZafEventType ZafScrolledWindow::ScrollEvent(const ZafEventStruct &event)
{
	return event.type;
}

void ZafScrolledWindow::OSSize(void)
{
	// Defer to the base class.
	ZafWindow::OSSize();
}

