//	Zinc Application Framework - W_POPUP1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_htips.hpp>
#include <z_popup.hpp>

// ----- ZafPopUpItem ----------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafPopUpItem::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0 }
};

ZafEventType ZafPopUpItem::Draw(const ZafEventStruct &, ZafEventType )
{
	// Windows automatically displays text.
	return (FALSE);
}

ZafEventType ZafPopUpItem::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	if (ccode == E_OSEVENT)
		return ZafPopUpItem::OSEvent(event);

	switch (ccode)
	{
	case S_INITIALIZE:
	case S_DEINITIALIZE:
	case S_REGISTER_OBJECT:
		menu.Event(event);
		ccode = ZafWindowObject::Event(event);
		break;

	case S_CREATE:
		ccode = ZafWindowObject::Event(event);
		DrawMenuBar(RootObject()->OSScreenID(ZAF_FRAMEID));
		break;

	case S_DESTROY:
		{
		RemoveMenu((HMENU)screenID, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, MF_BYCOMMAND);
		if (menu.screenID)
			DestroyMenu((HMENU)menu.screenID);
		Event(ZafEventStruct(S_DEINITIALIZE));
		}
		break;

	case S_CURRENT:
		ccode = ZafWindowObject::Event(event);
		Event(N_NON_CURRENT);
		break;

	case S_NON_CURRENT:
		// NotifyFocus() is not used by menus... propegate the message.
		if (menu.Focus())
			menu.Event(event);
		Event(N_NON_CURRENT);
		ccode = ZafWindowObject::Event(event);
		break;

	case N_CURRENT:
		// Update the helpTips help object.
		if (HelpObjectTip() && RootObject()->Focus())
		{
			ZafEventStruct tEvent = event;
			tEvent.type = DH_UPDATE_HELP_OBJECT;
			tEvent.windowObject = this;
			eventManager->Event(tEvent, E_HELPTIPS);
		}
		break;

	case N_NON_CURRENT:
		// Update the helpTips help object.
		if (HelpObjectTip())
		{
			ZafEventStruct tEvent = event;
			tEvent.type = DH_UPDATE_HELP_OBJECT;
			tEvent.windowObject = ZAF_NULLP(ZafWindowObject);
			eventManager->Event(tEvent, E_HELPTIPS);
		}
		break;

	case L_SELECT:
		ccode = ZafButton::Event(event);
		break;

	default:
		ccode = ZafWindowObject::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

bool ZafPopUpItem::SetDisabled(bool setDisabled)
{
	if (setDisabled != disabled)
	{
		// Set the attribute.
		disabled = setDisabled;

		// Set the selectabilty with the OS.
		if (screenID)
			EnableMenuItem((HMENU)screenID, ListIndex(), MF_BYPOSITION | (disabled ? MF_GRAYED : MF_ENABLED));
	}

	return disabled;
}

// ----- OS Specific Functions ----------------------------------------------

ZafEventType ZafPopUpItem::OSEvent(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (event.osEvent.message)
	{
	case WM_COMMAND:
		// Item was selected.
		Event(ZafEventStruct(L_SELECT));
		break;
	
	default:
		ccode = ZafWindowObject::Event(event);
	}

	return (ccode);
}

void ZafPopUpItem::OSRegisterObject(void)
{
	screenID = parent->screenID;

	UINT flags = MF_STRING;
	if (ItemType() == ZAF_SEPARATOR)
		flags |= MF_SEPARATOR;
	if (menu.First())
		flags |= MF_POPUP;
	if (disabled)
		flags |= MF_GRAYED | MF_DISABLED;

	if (ZafMSWindowsApp::convertText)
	{
		char *osText = stringData ?
			zafCodeSet->ConvertToOSString(*stringData, ZAF_NULLP(char), false) :
			ZAF_NULLP(char);
#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
		AppendMenuA((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#else
		AppendMenu((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#endif
	}
#if defined(ZAF_WIN32) || !defined(ZAF_UNICODE)
	else
		AppendMenu((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID,
			stringData ? stringData->Text() : ZAF_NULLP(ZafIChar));
#endif
}

// ----- Stubs --------------------------------------------------------------

void ZafPopUpItem::OSMapPalette(ZafPaletteStruct &, ZafPaletteType, ZafPaletteState)
{
}

ZafError ZafPopUpItem::OSSetText(void)
{
	return ZAF_ERROR_NONE;
}

void ZafPopUpItem::OSSize(void)
{
}

bool ZafPopUpItem::SetSelected(bool)
{
//??? MNF_CHECK_MARK?
	return selected;
}
