//	Zinc Application Framework - W_KEYBRD.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_evtmgr.hpp>
#include <z_keybrd.hpp>
#define ZAF_KEYBOARD_INFO
#include "gbl_def.cpp"

// ----- ZafKeyboard -------------------------------------------------------

ZafKeyboard::ZafKeyboard(ZafDeviceState _state) :
	ZafDevice(E_KEY, _state)
{
	installed = true;
}

ZafKeyboard::~ZafKeyboard(void)
{
	installed = false;
}

ZafEventType ZafKeyboard::Event(const ZafEventStruct &event)
{
	// Switch on the event type.
	ZafEventType ccode = event.type;
	switch (event.type)
	{
	case D_OFF:
	case D_ON:
		deviceState = ccode;
		break;

	case D_STATE:
		return (deviceState);
	}

	// Return the ccode.
	return (ccode);
}

void ZafKeyboard::Poll(void)
{
	// This code takes events off the queue if keyboard is turned off.
	ZafEventStruct event;
	if (DeviceState() == D_OFF &&
		eventManager->Get(event, Q_BEGIN | Q_NO_DESTROY | Q_NO_POLL) == 0 &&
		(event.type == E_KEY || (event.type == E_OSEVENT && event.InputType() == E_KEY)))
		eventManager->Get(event, Q_BEGIN | Q_NO_POLL);
}

