#include <z_bitmap.hpp>
#include <z_list.hpp>

#if defined(ZAF_WIN32)
class ZAF_EXPORT ZafTreeImageItem;
class ZAF_EXPORT ZafTreeImageList : private ZafList
{
	ZafDisplay *display;
	int images, maxImages;
	HIMAGELIST handle;
	HWND treeHandle;

public:
	ZafTreeImageList(ZafDisplay *display, HWND treeHandle);
	virtual ~ZafTreeImageList(void);

	int AddImage(ZafBitmapData *bitmapData);
	int GetImageIndex(ZafBitmapData *bitmapData);
	void SubtractImage(ZafBitmapData *bitmapData);

	HIMAGELIST Handle(void) { return handle; };
};

class ZAF_EXPORT ZafTreeImageItem : public ZafElement
{
public:
	int count, index;
	ZafBitmapData *bitmapData;

	ZafTreeImageItem(ZafBitmapData *bitmapData, int index);
	virtual ~ZafTreeImageItem(void);
};
#endif


