//	Zinc Application Framework - W_I18N.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_idata.hpp>
#include <z_string.hpp>
#include <z_stdlib.hpp>
#include <z_stdio.hpp>
#include <z_cset.hpp>
#include "w_app.hpp"

struct WinToMap
{
	int value;
	ZafIChar name[20];
};

static WinToMap winToMap[] =
{
	{ ANSI_CHARSET,			ZAF_ITEXT("ISO8859-1")},
	{ 3,					ZAF_ITEXT("1252")},
	{ SHIFTJIS_CHARSET,		ZAF_ITEXT("932")},
	{ HANGEUL_CHARSET,		ZAF_ITEXT("949")},
	// Simplified Chinese.
	{ 134,					ZAF_ITEXT("1381")},
	{ CHINESEBIG5_CHARSET,	ZAF_ITEXT("9500")},
	// Hebrew
	{ 177,					ZAF_ITEXT("1255")},
	// Arabic
	{ 178,					ZAF_ITEXT("1256")},
	// Traditional Arabic
	{ 179,					ZAF_ITEXT("1256")},
	// Andulas??
	{ 180,					ZAF_ITEXT("1254")},
	// Cyrillic
	{ 204,					ZAF_ITEXT("1251")},
	// Central Europe
	{ 238,					ZAF_ITEXT("1250")},
	{ -1,					ZAF_ITEXT("ASCII")},
};

void LocalCopy(char *source, ZafIChar *destination, int max);

static const ZafIChar *OSCodeSetName(bool &osNativeUnicode)
{
	osNativeUnicode = (ZafMSWindowsApp::convertText) ? false : true;
	// Find the name of the code set from the operating system.
#if !defined(ZAF_WIN32)
	HFONT systemFont = (HFONT)GetStockObject(SYSTEM_FONT);
	LOGFONT systemInfo;
	::GetObject(systemFont, sizeof(LOGFONT), (LPSTR)&systemInfo);
	int charSet = systemInfo.lfCharSet;
	int k;
	for (k = 0; winToMap[k].value != -1; k++)
		if (charSet == winToMap[k].value)
			break;

	return (winToMap[k].name);
#else
	static ZafIChar retVal[10];
	static char temp[10];
	UINT codePage = GetOEMCP();
	#undef sprintf
	::sprintf(temp, "%d", codePage);
	LocalCopy(temp, retVal, 10);
	return (retVal);
#endif
}

const ZafIChar *ZafI18nData::OSI18nName(void)
{
	static ZafIChar osI18nName[15];
	ZafIChar temp[20];
	char osTemp[20];

	char intlString[] = { 'I','n','t','l', 0 };
	char iCountry[] = { 'i','C','o','u','n','t','r','y', 0 };
	char sLanguage[] = { 's','L','a','n','g','u','a','g','e', 0 };

	// Check ZINC_LANG
#undef getenv
	char *zafLangName = getenv("ZAF_LANG");

	if (zafLangName && *zafLangName)
	{
		LocalCopy(zafLangName, osI18nName, 15);
	}
	else
	{
		osTemp[0] = '\0';
		// Get the language.
		GetProfileString(intlString, sLanguage, osTemp, osTemp, sizeof(osTemp));
		strlwr(osTemp);
		LocalCopy(osTemp, temp, 20);
		const ZafIChar *langName = OSLanguageToZafLanguage(temp);
		if (langName)
			strcpy(osI18nName, langName);

		// Get the locale.
		int countryCode = GetProfileInt(intlString, iCountry, 0);
		const ZafIChar *locName = CountryCodeToZafLocale(countryCode);
		if (locName)
		{
			strcat(osI18nName, ZAF_ITEXT("_"));
			strcat(osI18nName, locName);
		}

		bool tmp;
		const ZafIChar *codeSetName = OSCodeSetName(tmp);
		if (codeSetName)
		{
			strcat(osI18nName, ZAF_ITEXT("."));
			strcat(osI18nName, codeSetName);
		}
	}

	//Check OS information
	return (osI18nName);
}

void LocalCopy(char *source, ZafIChar *destination, int max)
{
	if (max < 0)
		max = strlen(source);
	int i;
	for (i = 0; i < max && source[i]; i++)
		destination[i] = source[i];
	if (i < max)
		destination[i] = '\0';
}

