//	Zinc Application Framework - W_CURSOR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_cursor.hpp>
#include <z_win.hpp>
#define ZAF_CURSOR_INFO
#include "gbl_def.cpp"

// ----- ZafCursor ---------------------------------------------------------

int ZafCursor::blinkRate = 0;

ZafCursor::ZafCursor(ZafDeviceState _state, ZafDeviceImage _imageType) :
	ZafDevice(E_CURSOR, _state), imageType(_imageType)
{
	// Check the image information.
	ImageAllocate();

	// Initialize the cursor information.
	position.column = position.line = 0;
	offset.column = offset.line = 0;
	installed = true;

	blinkRate = GetCaretBlinkTime();
}

ZafCursor::~ZafCursor(void)
{
	// Check the image information.
	ImageFree();
}

ZafEventType ZafCursor::Event(const ZafEventStruct &event)
{
	// Switch on the event type.
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case D_OFF:
	case D_ON:
		// Change the cursor state for the current object.
		deviceState = ccode;
		if (ccode == D_ON)
			ShowCaret(NULL);
		else
			HideCaret(NULL);
		break;

	case D_STATE:
		return (deviceState);

	case DC_INSERT:
	case DC_OVERSTRIKE:
		SetImageType(ccode);
		break;
	}

	// Return the ccode.
	return (ccode);
}

void ZafCursor::ImageAllocate(void)
{
}

void ZafCursor::ImageFree(bool)
{
}

void ZafCursor::Poll(void)
{
	// No action needed.
}

int ZafCursor::SetBlinkRate(int setBlinkRate)
{
	blinkRate = setBlinkRate;

	// Set the blink rate in Windows.
	SetCaretBlinkTime(blinkRate);

	return (blinkRate);
}

ZafDeviceImage ZafCursor::SetImageType(ZafDeviceImage tImageType)
{
	imageType = tImageType;
	return (imageType);
}

