//	Zinc Application Framework - W_BORDER.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_border.hpp>

// ----- ZafBorder ---------------------------------------------------------

int ZafBorder::width = 0;

ZafPaletteMap ZAF_FARDATA ZafBorder::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0 }
};

ZafEventType ZafBorder::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// Windows automatically displays the border.
	return (ccode);
}

ZafEventType ZafBorder::Event(const ZafEventStruct &event)
{
 	if (event.type == S_REGISTER_OBJECT)
		screenID = parent->OSScreenID(ZAF_FRAMEID);
	else if (event.type == S_DEINITIALIZE)
		screenID = 0;

	return (S_UNKNOWN);
}

// ----- OS Specific Functions ----------------------------------------------

void ZafBorder::GetClip(ZafWindowObject *, ZafRegionStruct &, ZafRegionStruct &)
{
	// Handled automatically by Windows.
}

ZafError ZafBorder::OSGetWidth(void)
{
	// Border must have a parent to know its size.
	ZafWindow *window = DynamicPtrCast(parent, ZafWindow);
	if (window)
	{
		// Determine what type of border it is.
		int metricsIndex;
		if (window->IsA(ID_ZAF_DIALOG_WINDOW))
			metricsIndex = SM_CXDLGFRAME;
		else if (window->Sizeable())
			metricsIndex = SM_CXFRAME;
		else
			metricsIndex = SM_CXBORDER;

		// Get the border width from windows.
		width = GetSystemMetrics(metricsIndex);

		return ZAF_ERROR_NONE;
	}

	// No parent.
	return ZAF_ERROR_INVALID;
}

void ZafBorder::OSMapPalette(ZafPaletteStruct &, ZafPaletteType, ZafPaletteState)
{
}

void ZafBorder::OSRegisterObject(void)
{
}

ZafError ZafBorder::OSSetWidth(void)
{
	// Border width can't be changed in Windows.
	return ZAF_ERROR_INVALID;
}

void ZafBorder::OSSize(void)
{
	// Handled automatically by Windows.
}

ZafError ZafBorder::OSUpdatePalettes(ZafPaletteType, ZafPaletteType)
{
	return (ZAF_ERROR_NONE);
}
