//	Zinc Application Framework - W_APP.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

//??? This is where I list my general bugs/issues so they don't get lost.
//??? Support object should be handled at the window object level?
//??? There is redundant protection for include files?

#include "w_app.hpp"
#include <z_app.hpp>
#include <z_string.hpp>

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int)
{
	// Only one instance of the app can be run at a time in Windows 3.X.
	if (hPrevInstance)
		return (1);

	// Initialize the Windows specific application tools/information.
	ZafMSWindowsApp windowsApp(hInstance);

	// Create portable "argc" and "argv" variables.
	char pathName[ZAF_MAXPATHLEN];
#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
	GetModuleFileNameA(hInstance, pathName, ZAF_MAXPATHLEN);
#else
	GetModuleFileName(hInstance, pathName, ZAF_MAXPATHLEN);
#endif
	char *argString = strdup(lpszCmdLine);

//??? How are quoted arguments handled.
	// Compute "argc."
	int argc = 1;
	if (argString && *argString)
	{
		char *pos = argString;
		while (*pos)
		{
			if (*pos != ' ' && *pos != '\t')
			{
				argc++;
				while (*pos && *pos != ' ' && *pos != '\t')
					pos++;
			}
			else
				pos++;
		}
	}

	// Create "argv."
	char **argv = new char *[argc + 1];
	argv[0] = pathName;
	if (argc > 1)
	{
		int arg = 1;
		char *pos = argString;
		while (*pos)
		{
			if (*pos != ' ' && *pos != '\t')
			{
				argv[arg++] = pos;
				while (*pos && *pos != ' ' && *pos != '\t')
					pos++;
				if (*pos)
					*pos++ = 0;
			}
			else
				pos++;
		}
	}
	argv[argc] = ZAF_NULLP(char);

//??? Development Only
#if defined(ZAF_DEBUG)
	debug = fopen("debug.txt", "wt");

	char *platform;
	if (ZafMSWindowsApp::windowsPlatform == ZAF_WIN16)
		platform = "Windows";
	else if (ZafMSWindowsApp::windowsPlatform == ZAF_WIN32S)
		platform = "Win 32s";
	else if (ZafMSWindowsApp::windowsPlatform == ZAF_WIN32_WINDOWS)
		platform = "Windows 95";
	else if (ZafMSWindowsApp::windowsPlatform == ZAF_WIN32_NT)
		platform = "Windows NT";
	int majorVersion = ZafMSWindowsApp::windowsVersion / 100;
	int minorVersion = ZafMSWindowsApp::windowsVersion % 100;
	fprintf(debug, "%s, Version %d.%d", platform, majorVersion, minorVersion);
	flushall();
#endif

	// Call the application program.
	ZafApplication application(argc, argv);
	int returnValue = application.Main();

//??? Development Only
#if defined(ZAF_DEBUG)
	fclose(debug);
#endif

	// Clean up.
	delete []argv;
	delete []argString;

	return (returnValue);
}

// Some linkers don't look for WinMain in the .LIBs.  This stub can be
// called to force such linkers to link this module with an application
// so that WinMain will be available.
void ZafApplication::LinkMain(void)
{
}

