# Zinc Application Framework 5.0 test programs makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc test programs for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
ZAF_ROOT=..\..

!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Test Programs --------------------------
# This is pending.

# ----- Windows 16 bit Test Programs ----------------------------------------
win16: wtbl1_16.exe wtbl2_16.exe wtbl3_16.exe wtbl4_16.exe .SYMBOLIC

wtbl1_16.exe: table1.ob1 data.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbl1_16.exe F table1.ob1,data.ob1 $(WIN_OBJS) L $(WIN_LIBS)

wtbl2_16.exe: table2.ob1 data.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbl2_16.exe F table2.ob1,data.ob1 $(WIN_OBJS) L $(WIN_LIBS)

wtbl3_16.exe: table3.ob1 data.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbl3_16.exe F table3.ob1,data.ob1 $(WIN_OBJS) L $(WIN_LIBS)

wtbl4_16.exe: table4.ob1 data.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbl4_16.exe F table4.ob1,data.ob1 $(WIN_OBJS) L $(WIN_LIBS)

# ----- Windows 32 bit Test Programs ----------------------------------------
win32: wtbl1_32.exe wtbl2_32.exe wtbl3_32.exe wtbl4_32.exe .SYMBOLIC

wtbl1_32.exe: table1.obw data.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbl1_32.exe F table1.obw,data.obw $(W32_OBJS) L $(W32_LIBS)

wtbl2_32.exe: table2.obw data.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbl2_32.exe F table2.obw,data.obw $(W32_OBJS) L $(W32_LIBS)

wtbl3_32.exe: table3.obw data.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbl3_32.exe F table3.obw,data.obw $(W32_OBJS) L $(W32_LIBS)

wtbl4_32.exe: table4.obw data.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbl4_32.exe F table4.obw,data.obw $(W32_OBJS) L $(W32_LIBS)

# ----- Windows 32 bit dll Test Programs -------------------------------------
win32dll: wtable1.exe wtable2.exe wtable3.exe wtable4.exe .SYMBOLIC

wtable1.exe: table1.obi	data.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtable1.exe F table1.obi,data.obi $(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtable2.exe: table2.obi	data.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtable2.exe F table2.obi,data.obi $(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtable3.exe: table3.obi	data.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtable3.exe F table3.obi,data.obi $(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtable4.exe: table4.obi	data.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtable4.exe F table4.obi,data.obi $(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

# ----- OS/2 Test Programs --------------------------------------------------
# This is pending.


# ----- DESQview/X Test Programs --------------------------------------------
dvx: mtable1.exe mtable2.exe mtable3.exe mtable4.exe

mtable1.exe: table1.obm	data.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtable1.exe F mtable1.obm,data.obm $(DVX_OBJS) L $(DVX_LIBS)

mtable2.exe: table2.obm	data.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtable2.exe F mtable2.obm,data.obm $(DVX_OBJS) L $(DVX_LIBS)

mtable3.exe: table3.obm	data.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtable3.exe F mtable3.obm,data.obm $(DVX_OBJS) L $(DVX_LIBS)

mtable4.exe: table4.obm	data.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtable4.exe F mtable4.obm,data.obm $(DVX_OBJS) L $(DVX_LIBS)

# ----- QNX Motif Test Programs ---------------------------------------------
qnx: mtable1 mtable2 mtable3 mtable4

mtable1: table1.o data.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ table1.o data.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtable2: table2.o data.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ table2.o data.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtable3: table3.o data.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ table3.o data.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtable4: table4.o data.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ table4.o data.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mtable1 mtable2
