//	Zinc Application Framework - TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>
#include <data.hpp>

struct StudentRecord
{
	ZafIChar name[32];
	ZafIChar finalGrade[4];
	int homework;
	int tests;
	int final;
};

struct SampleData
{
	ZafIChar *name;
	ZafIChar *finalGrade;
	int homework;
	int tests;
	int final;
} sampleData[] =
{
	{ ZAF_ITEXT("Curly"), ZAF_ITEXT("F"), 17, 35, 3 },
	{ ZAF_ITEXT("Einstein, Albert"), ZAF_ITEXT("B"), 50, 85, 98 },
	{ ZAF_ITEXT("Fool, Big"), ZAF_ITEXT("A"), 100, 95, 85 },
	{ ZAF_ITEXT("Mo"), ZAF_ITEXT("F"), 12, 20, 11},
	{ ZAF_NULLP(ZafIChar), ZAF_NULLP(ZafIChar), 0, 0, 0 },
};

// ----- SampleTable --------------------------------------------------------

class SampleTable : public ZafTable
{
public:
	SampleTable(SimpleDatabase *database);

	virtual ZafError ReadRecord(ZafTableRecord &record, ZafWindowObject *row);
	virtual ZafError WriteRecord(ZafTableRecord &record, ZafWindowObject *row);

private:
	SimpleDatabase *database;
};

SampleTable::SampleTable(SimpleDatabase *setDatabase) :
	ZafTable(0, 0, 0, 0, 0, 1, 1),
	database(setDatabase)
{
	// Set attributes.
//	SetGrid(false);
	SetRegionType(ZAF_AVAILABLE_REGION);

	// Add Columns
	Add(new ZafString(0, 0, 20, ZAF_NULLP(ZafIChar), 32), ZAF_ITEXT("Name"));
	Add(new ZafInteger(20, 0, 7), ZAF_ITEXT("Homework"));
	Add(new ZafInteger(27, 0, 7), ZAF_ITEXT("Tests"));
	Add(new ZafInteger(34, 0, 7), ZAF_ITEXT("Final"));
	Add(new ZafString(41, 0, 11), ZAF_ITEXT("Final Grade"));

	// Add the scroll-bar.
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL));

	// Set the number of records.
	maxOffset = database->Records() - 1;
}

ZafError SampleTable::ReadRecord(ZafTableRecord &record, ZafWindowObject *)
{
	StudentRecord studentRecord;
	database->SeekRandomRecord(currentOffset, &studentRecord);

	record(0)->SetText(studentRecord.name);
	DynamicPtrCast(record(1), ZafInteger)->IntegerData()->SetInteger(studentRecord.homework);
	DynamicPtrCast(record(2), ZafInteger)->IntegerData()->SetInteger(studentRecord.tests);
	DynamicPtrCast(record(3), ZafInteger)->IntegerData()->SetInteger(studentRecord.final);
	record(4)->SetText(studentRecord.finalGrade);

	return (ZAF_ERROR_NONE);
}

ZafError SampleTable::WriteRecord(ZafTableRecord &record, ZafWindowObject *)
{
	StudentRecord studentRecord;
	strcpy(studentRecord.name, record(0)->Text());
	studentRecord.homework = DynamicPtrCast(record(1), ZafInteger)->IntegerData()->Value();
	studentRecord.tests = DynamicPtrCast(record(2), ZafInteger)->IntegerData()->Value();
	studentRecord.final = DynamicPtrCast(record(3), ZafInteger)->IntegerData()->Value();
	strcpy(studentRecord.finalGrade, record(4)->Text());

	database->ModifyRecord(currentOffset, &studentRecord);

	return (ZAF_ERROR_NONE);
}

// ----- SampleTableWindow --------------------------------------------------

const ZafUserEvent INSERT_RECORD	= U_USER_FIRST;
const ZafUserEvent DELETE_RECORD	= U_USER_FIRST + 1;

class SampleTableWindow : public ZafWindow
{
public:
	SampleTableWindow(int left, int top, int width, int height);
	ZafEventType Event(const ZafEventStruct &event);

protected:
	SimpleDatabase *database;
	ZafTable *table;
};

SampleTableWindow::SampleTableWindow(int left, int top, int width, int height) :
	ZafWindow(left, top, width, height)
{
	AddGenericObjects(new ZafStringData("Database Table"));

	ZafPullDownMenu *pullDownMenu = new ZafPullDownMenu();
	ZafPullDownItem *pullDownItem = new ZafPullDownItem(ZAF_ITEXT("File"));
	pullDownMenu->Add(pullDownItem);
	Add(pullDownMenu);

	ZafToolBar *toolbar = new ZafToolBar(0, 0, 0, 1);

	ZafButton *button = new ZafButton(0, 0, 10, 1, "Insert");
	button->SetSendMessageWhenSelected(true);
	button->SetValue(INSERT_RECORD);
	toolbar->Add(button);

	button = new ZafButton(0, 0, 10, 1, "Delete");
	button->SetSendMessageWhenSelected(true);
	button->SetValue(DELETE_RECORD);
	toolbar->Add(button);

	Add(toolbar);

	// Initialize the database.
	database = new SimpleDatabase(sizeof(StudentRecord));
	for (int index = 0; sampleData[index].name; index++)
	{
		StudentRecord studentRecord;
		strcpy(studentRecord.name, sampleData[index].name);
		strcpy(studentRecord.finalGrade, sampleData[index].finalGrade);
		studentRecord.homework = sampleData[index].homework;
		studentRecord.tests = sampleData[index].tests;
		studentRecord.final = sampleData[index].final;
		database->AddRecord(&studentRecord);
	}

	table = new SampleTable(database);
	Add(table);
}

ZafEventType SampleTableWindow::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (ccode)
	{
	case INSERT_RECORD:
		if (table->Current() || database->Records() == 0)
		{
			int currentOffset = table->Current() ? (int)table->Current()->Offset() : 0;
			StudentRecord newStudentRecord;
			strcpy(newStudentRecord.name, "New Student");
			newStudentRecord.finalGrade[0] = 0;
			newStudentRecord.homework = 0;
			newStudentRecord.tests = 0;
			newStudentRecord.final = 0;
			database->AddRecord(&newStudentRecord, currentOffset);
			table->InsertRecord(currentOffset);
		}
		break;

	case DELETE_RECORD:
		if (table->Current())
		{
			int currentOffset = (int)table->Current()->Offset();
			database->DeleteRecord(currentOffset);
			table->DeleteRecord(currentOffset);
		}
		break;

	default:
		ccode = ZafWindow::Event(event);
	}

	return(ccode);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	ZafWindow *window = new SampleTableWindow(0, 0, 60, 15);
	zafWindowManager->Center(window);
	zafWindowManager->Add(window);

	Control();

	// Return success.
	return (0);
}

