//	Zinc Application Framework - TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>
#include <data.hpp>

struct StudentRecord
{
	ZafIChar name[32];
	ZafIChar finalGrade[4];
	int homework;
	int tests;
	int final;
};

struct SampleData
{
	ZafIChar *name;
	ZafIChar *finalGrade;
	int homework;
	int tests;
	int final;
} sampleData[] =
{
	{ ZAF_ITEXT("Curly"), ZAF_ITEXT("F"), 17, 35, 3 },
	{ ZAF_ITEXT("Einstein, Albert"), ZAF_ITEXT("B"), 50, 85, 98 },
	{ ZAF_ITEXT("Fool, Big"), ZAF_ITEXT("A"), 100, 95, 85 },
	{ ZAF_ITEXT("Mo"), ZAF_ITEXT("F"), 12, 20, 11},
	{ ZAF_NULLP(ZafIChar), ZAF_NULLP(ZafIChar), 0, 0, 0 },
};

// ----- SampleTable --------------------------------------------------------

class SampleTable : public ZafTable
{
public:
	SampleTable(SimpleDatabase *database);

	virtual ZafError ReadRecord(ZafTableRecord &record, ZafWindowObject *row);
	virtual ZafError WriteRecord(ZafTableRecord &record, ZafWindowObject *row);

private:
	SimpleDatabase *database;
};

SampleTable::SampleTable(SimpleDatabase *setDatabase) :
	ZafTable(0, 0, 0, 0, 0, 1, 1),
	database(setDatabase)
{
	// Set attributes.
	SetGrid(false);
	SetRegionType(ZAF_AVAILABLE_REGION);

	// Add Columns
	ZafWindowObject *recordField = new ZafString(0, 0, 20, ZAF_NULLP(ZafIChar), 32);
	recordField->SetBordered(false);
	Add(recordField, ZAF_ITEXT("Name"));
	recordField = new ZafInteger(20, 0, 7);
	recordField->SetBordered(false);
	Add(recordField, ZAF_ITEXT("Homework"));
	recordField = new ZafInteger(27, 0, 7);
	recordField->SetBordered(false);
	Add(recordField, ZAF_ITEXT("Tests"));
	recordField = new ZafInteger(34, 0, 7);
	recordField->SetBordered(false);
	Add(recordField, ZAF_ITEXT("Final"));
	recordField = new ZafString(41, 0, 10);
	recordField->SetBordered(false);
	Add(recordField, ZAF_ITEXT("Final Grade"));

	// Add the scroll-bar.
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL));

	// Set the number of records.
	maxOffset = database->Records() - 1;
}

ZafError SampleTable::ReadRecord(ZafTableRecord &record, ZafWindowObject *)
{
	StudentRecord studentRecord;
	database->SeekRandomRecord(currentOffset, &studentRecord);

	record(0)->SetText(studentRecord.name);
	DynamicPtrCast(record(1), ZafInteger)->IntegerData()->SetInteger(studentRecord.homework);
	DynamicPtrCast(record(2), ZafInteger)->IntegerData()->SetInteger(studentRecord.tests);
	DynamicPtrCast(record(3), ZafInteger)->IntegerData()->SetInteger(studentRecord.final);
	record(4)->SetText(studentRecord.finalGrade);

	return (ZAF_ERROR_NONE);
}

ZafError SampleTable::WriteRecord(ZafTableRecord &record, ZafWindowObject *)
{
	StudentRecord studentRecord;
	strcpy(studentRecord.name, record(0)->Text());
	studentRecord.homework = DynamicPtrCast(record(1), ZafInteger)->IntegerData()->Value();
	studentRecord.tests = DynamicPtrCast(record(2), ZafInteger)->IntegerData()->Value();
	studentRecord.final = DynamicPtrCast(record(3), ZafInteger)->IntegerData()->Value();
	strcpy(studentRecord.finalGrade, record(4)->Text());

	database->ModifyRecord(currentOffset, &studentRecord);

	return (ZAF_ERROR_NONE);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Initialize the database.
	SimpleDatabase *database = new SimpleDatabase(sizeof(StudentRecord));
	for (int index = 0; sampleData[index].name; index++)
	{
		StudentRecord studentRecord;
		strcpy(studentRecord.name, sampleData[index].name);
		strcpy(studentRecord.finalGrade, sampleData[index].finalGrade);
		studentRecord.homework = sampleData[index].homework;
		studentRecord.tests = sampleData[index].tests;
		studentRecord.final = sampleData[index].final;
		database->AddRecord(&studentRecord);
	}

	ZafWindow *window = new ZafWindow(0, 0, 60, 15);
	window->AddGenericObjects(new ZafStringData("Table Window"));
	window->Add(new SampleTable(database));
	zafWindowManager->Center(window);
	zafWindowManager->Add(window);

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

