## ----- Install options -----
CC = CC
LINK = CC
CC_FLAGS =
LINK_FLAGS =
CPP_EXTENSION = .cpp
INCLUDE_DIRS =
LIB_DIRS = -L/usr/lib/Motif1.2 -L/usr/lib/X11R5
GUI_LIBS = -lXm -lXt -lX11
LIBS = -lm

## ----- General options -----
ZAF_INC_DIR = ../../include
ZAF_LIB_DIR = ../../lib
Z_INCLUDE_DIRS = -I. -I$(ZAF_INC_DIR) $(INCLUDE_DIRS)
Z_LIB_DIRS = -L$(ZAF_LIB_DIR) $(LIB_DIRS)
Z_LIBS = -lZafMtf $(GUI_LIBS) $(LIBS)

.SUFFIXES:
.SUFFIXES: .o $(CPP_EXTENSION)

$(CPP_EXTENSION).o:
	$(CC) $(CC_FLAGS) $(Z_INCLUDE_DIRS) -c $<

posix: mtable1 mtable2 mtable3 mtable4

clean:
	-rm -f *.o core mtable1 mtable2 mtable3 mtable4

mtable1: table1.o data.o
	$(LINK) $(LINK_FLAGS) -o $@ table1.o data.o $(Z_LIB_DIRS) $(Z_LIBS)

mtable2: table2.o data.o
	$(LINK) $(LINK_FLAGS) -o $@ table2.o data.o $(Z_LIB_DIRS) $(Z_LIBS)

mtable3: table3.o data.o
	$(LINK) $(LINK_FLAGS) -o $@ table3.o data.o $(Z_LIB_DIRS) $(Z_LIBS)

mtable4: table4.o data.o
	$(LINK) $(LINK_FLAGS) -o $@ table4.o data.o $(Z_LIB_DIRS) $(Z_LIBS)
