#include <z_list.hpp>
#include <z_str.hpp>

class SimpleDatabase : protected ZafList
{
public:
	SimpleDatabase(int recordSize);
	virtual ~SimpleDatabase(void);

	void AddRecord(void *record, long index = -1);
	void DeleteRecord(int index);
	void ModifyRecord(int index, void *record);

	int Records(void) {	return (records); }
	int CurrentRecord(void *record = ZAF_NULLP(void));
	int SeekNextRecord(void *record = ZAF_NULLP(void));
	int SeekPreviousRecord(void *record = ZAF_NULLP(void));
	int SeekRandomRecord(int index, void *record = ZAF_NULLP(void));

private:
	int records;
	int recordSize;
	long currentIndex;
	ZafElement *currentElement;

	class RecordElement : public ZafElement
	{
	public:
		RecordElement(void *record, int recordSize);
		virtual ~RecordElement(void);

		void *Record(void) { return record; }
		void SetRecord(void *setRecord, int recordSize) { memcpy(record, setRecord, recordSize); }

	private:
		void *record;
	};
};
