#include "data.hpp"

SimpleDatabase::SimpleDatabase(int setRecordSize) :
	recordSize(setRecordSize), records(0), currentIndex(-1)
{
}

SimpleDatabase::~SimpleDatabase(void)
{
}

void SimpleDatabase::AddRecord(void *record, long index)
{
	if (index < 0)
		Add(new RecordElement(record, recordSize));
	else
	{
		ZafElement *positionElement = First();
		while (positionElement && index-- > 0)
			positionElement = positionElement->Next();
		Add(new RecordElement(record, recordSize), positionElement);
	}

	records++;
}

void SimpleDatabase::DeleteRecord(int index)
{
	ZafElement *element = First();
	while (element && index-- > 0)
		element = element->Next();

	if (element)
	{
		if (currentElement == element)
		{
			if (currentElement->Next())
				currentElement = currentElement->Next();
			else
			{
				currentElement = currentElement->Previous();
				currentIndex--;
			}
		}

		Subtract(element);
		delete element;
		records--;
	}
}

void SimpleDatabase::ModifyRecord(int index, void *record)
{
	ZafElement *element = First();
	while (element && index-- > 0)
		element = element->Next();

	if (element)
		((RecordElement *)element)->SetRecord(record, recordSize);
}

int SimpleDatabase::CurrentRecord(void *record)
{
	if (record && currentElement)
		memcpy(record, ((RecordElement *)currentElement)->Record(), recordSize);
	return (currentIndex);
}

int SimpleDatabase::SeekNextRecord(void *record)
{
	if (currentElement->Next())
	{
		currentElement = currentElement->Next();
		currentIndex++;
	}

	return (CurrentRecord(record));
}

int SimpleDatabase::SeekPreviousRecord(void *record)
{
	if (currentElement->Previous())
	{
		currentElement = currentElement->Previous();
		currentIndex++;
	}

	return (CurrentRecord(record));
}

int SimpleDatabase::SeekRandomRecord(int index, void *record)
{
	int i = index;
	ZafElement *element = First();
	while (element && i-- > 0)
		element = element->Next();

	if (element)
	{
		currentElement = element;
		currentIndex = index;
	}

	return (CurrentRecord(record));
}

SimpleDatabase::RecordElement::RecordElement(void *setRecord, int recordSize)
{
	record = new char[recordSize];
	memcpy(record, setRecord, recordSize);
}

SimpleDatabase::RecordElement::~RecordElement(void)
{
	delete []record;
}
