# Zinc Application Framework 5.0 test programs makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc test programs for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
ZAF_ROOT=..\..

!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Test Programs --------------------------
# This is pending.

# ----- Windows 16 bit Test Programs ----------------------------------------
win16: wlte1_16.exe wlte2_16.exe .SYMBOLIC

wlte1_16.exe: light1.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wlte1_16.exe F light1.ob1$(WIN_OBJS) L $(WIN_LIBS)

wlte2_16.exe: light2.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wlte2_16.exe F light2.ob1$(WIN_OBJS) L $(WIN_LIBS)

# ----- Windows 32 bit Test Programs ----------------------------------------
win32: wlte1_32.exe wlte2_32.exe .SYMBOLIC

wlte1_32.exe: light1.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wlte1_32.exe F light1.obw$(W32_OBJS) L $(W32_LIBS)

wlte2_32.exe: light2.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wlte2_32.exe F light2.obw$(W32_OBJS) L $(W32_LIBS)

# ----- Windows 32 bit dll Test Programs -------------------------------------
win32dll: wlte1.exe wlte2.exe .SYMBOLIC

wlte1.exe: light1.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wlte1.exe F light1.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wlte2.exe: light2.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wlte2.exe F light2.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

# ----- OS/2 Test Programs --------------------------------------------------
# This is pending.

# ----- QNX Motif Test Programs ---------------------------------------------
qnx: mlight1 mlight2 

mlight1: light1.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ light1.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mlight2: light2.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ light2.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mlight1 mlight2 
