//	Zinc Application Framework - STOPLITE.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

// StopLightWin Events.
const ZafEventType CHANGE_LIGHT_STATE = 10000;

// Light Events.
const ZafEventType TURN_ON = 10500;
const ZafEventType TURN_OFF = 10501;

enum LightColor
{
	RED_LIGHT 	 = 0,
	GREEN_LIGHT	 = 1,
	YELLOW_LIGHT = 2
};

class Light : public ZafWindowObject
{
public:
	Light(int left, int top, int width, int height, LightColor _color);
	~Light(){}
	virtual ZafEventType Event(const ZafEventStruct &event);

protected:
	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
};

class StopLight : public ZafWindow
{
public:
	StopLight();
	~StopLight(){}
	virtual ZafEventType Event(const ZafEventStruct &event);

protected:
 	Light *red, *yellow, *green;

	virtual ZafEventType Draw(const ZafEventStruct &event, ZafEventType ccode);
};

class StopLightWin : public ZafWindow
{
public:
	StopLightWin(int left, int top, int width, int height);
	virtual ~StopLightWin(){}
	virtual ZafEventType Event(const ZafEventStruct &event);

protected:
	StopLight *stopLight;
};

