//	Zinc Application Framework - LIGHT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <zaf.hpp>
#include <z_i18n.hpp>
#include "light1.hpp"

// ----- LIGHT WINDOW -------------------------------------------------------

LightWin::LightWin(int left, int top, int width, int height) :
	ZafWindow(left, top, width, height)
{
	// Create the button used to chagne the state of the light.
	ZafButton *button = new ZafButton(1, 4, 14, 1, new ZafStringData("Change Light State"));
	button->SetSendMessageWhenSelected(true);
	button->SetValue(CHANGE_LIGHT_STATE);

	// Add the objects to the window.
	AddGenericObjects(new ZafStringData("Light"));
	*this
		+ button
		+ (light = new Light(4, 1, 6, 2));

	// Center the Window.
	zafWindowManager->Center(this);
}

ZafEventType LightWin::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;
	switch(ccode)
	{
	case CHANGE_LIGHT_STATE:
		// Turn the light on or off.
		if (!light->Disabled())
			// Turn it off.
			light->SetDisabled(true);
		else
			// Turn it on.
			light->SetDisabled(false);
		// Redisplay to show the new state.
		light->Redisplay();
		break;
	default:
		ccode = ZafWindow::Event(event);
		break;
	}
	return(ccode);

}

// ----- Light Object -------------------------------------------------------

Light::Light(int left, int top, int width, int height) :
	ZafWindowObject(left, top, width, height)
{

	// Create a ZafPaletteData.
	SetUserPaletteData(new ZafPaletteData());

	// If disabled attribute is set to true the light is in the off state.
	// If disabled attribute is set	to false the light is in the on state.
	// Create the palette to be used when the light is off.
	ZafPaletteStruct drawPalette = userPaletteData->GetPalette(ZAF_PM_FOREGROUND,
		ZAF_PM_DISABLED);
	drawPalette.colorForeground = drawPalette.colorBackground = ZAF_CLR_GREEN;

	// Add the palette to the palette table.
	userPaletteData->AddPalette(ZAF_PM_FOREGROUND, ZAF_PM_DISABLED, drawPalette);
	
	// Create the palette to be used when the light is on.
	drawPalette = userPaletteData->GetPalette(ZAF_PM_FOREGROUND, ZAF_PM_ENABLED);
	drawPalette.colorForeground = ZAF_CLR_GREEN;
	drawPalette.colorBackground = ZAF_CLR_LIGHTGREEN;

	// Add the palette to the palette table.
	userPaletteData->AddPalette(ZAF_PM_FOREGROUND, ZAF_PM_ENABLED, drawPalette);

	// Turn off the OSDraw so Draw() function will be called.
	SetOSDraw(false);
	// Set light's state to off, and make it noncurrent.
	SetDisabled(true);
	SetNoncurrent(true);
}

ZafEventType Light::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	ZafRegionStruct drawRegion = BeginDraw();

	// Set the palette the light should be drawn with.
	display->SetPalette(LogicalPalette(ZAF_PM_FOREGROUND, PaletteState()));

	// The Light is an ellipse drawn 1 pixel inside of the objects region.
	display->Ellipse(drawRegion.left + 1, drawRegion.top + 1,
		drawRegion.right - 1, drawRegion.bottom - 1, 
		0, 360, 2, true);

	EndDraw();
	return (ccode);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Create and add the StopLight window.
	*zafWindowManager
		+ new LightWin(0, 0, 16, 6);

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

