# ----- General Definitions -------------------------------------------------
ZAF_ROOT=..\..
DEBUG=off

usage:
	@type &&|

Usage:

make -f borland.mak win16      (16 bit Windows)
make -f borland.mak win32      (32 bit Windows)
make -f borland.mak win32dll   (32 bit Windows dll's)
|

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- Windows -------------------------------------------------------------
win16: wlte1_16 wlte2_16 

# ----- 32 bit Windows ------------------------------------------------------
win32: wlte1_32 wlte2_32 

# ----- 32 bit Windows DLLS -------------------------------------------------
win32dll: wlte1 wlte2

# ----- Test Programs -------------------------------------------------------

!if "$(TARGET)" == "wlte1.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=light1.cpp
!endif

!if "$(TARGET)" == "wlte2.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=light2.cpp
!endif

!if "$(TARGET)" == "wlte1_32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=light1.cpp
!endif

!if "$(TARGET)" == "wlte2_32.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=light2.cpp
!endif

!if "$(TARGET)" == "wlte1_16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=light1.cpp
DEFINITION_FILE=win16.def
!endif

!if "$(TARGET)" == "wlte2_16.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=light2.cpp
DEFINITION_FILE=win16.def
!endif

!ifdef TARGET
# When options defined, build using ZAF 5 make files for Borland
!include "$(ZAF_ROOT)\include\zafbor.mak"

!else
# Define options (macros) based on command-line platform

wlte1_16 wlte2_16 \
wlte1_32 wlte2_32 \
wlte1 wlte2 :
	@ECHO .
	@ECHO .
	@ECHO Making $<.exe...
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe
!endif

