#include <zaf.hpp>
#include <z_prst.hpp>

ZafApplication::Main()
{
	// This line is only needed for linkers that don't automatically look
	// for unresolved references to main() or WinMain() inside of libraries.
	// (main() or WinMain() is found in a ZAF library)
	LinkMain();

	// Create a storage object for reading the data file.
	// (This is the low level mechanism for talking to the disk file.)
	// (The optional ZAF_ITEXT macro guarantees unicode compatibility.)
	ZafStorage storage(ZAF_ITEXT("hello.znc"), ZAF_FILE_READ);

	// Create a persistence object for loading the hello window.
	// Persistence provides the link between persitable objects and an
	// abstract file system (ZafStorage in this case).
	// Important: Because ZafObjectPersistence currently maintains a large
	//   amount of static data, those with stack size limitations should use
	//   the "new" operator to allocate it in the heap.
	ZafObjectPersistence *persistence =
		new ZafObjectPersistence(&storage, zafDefaultDataConstructor,
			zafDefaultObjectConstructor);

	// Load the hello window from the data (.znc) file.
	ZafWindow *helloWindow = new ZafWindow(ZAF_ITEXT("HelloWindow"), *persistence);

	// Center the window on the screen.
	zafWindowManager->Center(helloWindow);

	// Attach the hello window to the window manager, or in other words,
	// make it appear on the screen.
	zafWindowManager->Add(helloWindow);

	// Process events.
	// (This functions passes events from the event manager to the
	// window manager until an S_EXIT is received or until there on no
	// more windows attached to the window manager.)
	Control();

	// Free the persistence allocated above.
	delete persistence;

	// Return an exit code.
	// (This is the exit code returned to the OS by the application.)
	return (0);
}
