#include <zaf.hpp>

ZafApplication::Main()
{
	// This line is only needed for linkers that don't automatically look
	// for unresolved references to main() or WinMain() inside of libraries.
	// (main() or WinMain() is found in a ZAF library)
	LinkMain();

	// Create the hello window and attach generic objects (border, maximize
	// button, minimize button, system button, and title) to it.
	ZafWindow *helloWindow = new ZafWindow(0, 0, 30, 3);
	helloWindow->AddGenericObjects(new ZafStringData("Hello Window"));

	// Attach a prompt with the "hello world" text.
	// (The optional ZAF_ITEXT macro guarantees unicode compatibility.)
	helloWindow->Add(new ZafPrompt(2, 1, 0, ZAF_ITEXT("Hello World!")));

	// Center the window on the screen.
	zafWindowManager->Center(helloWindow);

	// Attach the hello window to the window manager, or in other words,
	// make it appear on the screen.
	zafWindowManager->Add(helloWindow);

	// Process events.
	// (This functions passes events from the event manager to the
	// window manager until an S_EXIT is received or until there on no
	// more windows attached to the window manager.)
	Control();

	// Return an exit code.
	// (This is the exit code returned to the OS by the application.)
	return (0);
}
