# Zinc Application Framework 5.0 attrtest makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc attrtest programs for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
VERSION=watcom
PERSISTENCE=all

ZAF_ROOT=..\..

PERSISTENCE=all
!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Attrtest Programs ----------------------
# This is pending.

# ----- Windows 16 bit Attrtest Programs ------------------------------------
win16: wbmp116.exe wbmp216.exe wbmp316.exe wbmp416.exe

wbmp116.exe: main1.ob1 bitmap1.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbmp116 F main1.ob1,bitmap1.ob1$(WIN_OBJS) L $(WIN_LIBS)

wbmp216.exe: main2.ob1 bitmap2.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbmp216 F main2.ob1,bitmap2.ob1$(WIN_OBJS) L $(WIN_LIBS)

wbmp316.exe: main3.ob1 bitmap3.ob1 bitmap2.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbmp316 F main3.ob1,bitmap3.ob1,bitmap2.ob1$(WIN_OBJS) L $(WIN_LIBS)

wbmp416.exe: main4.ob1 bitmap4.ob1 bitmap2.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbmp416 F main4.ob1,bitmap4.ob1,bitmap2.ob1$(WIN_OBJS) L $(WIN_LIBS)

# ----- Windows 32 bit Attrtest Programs ------------------------------------
win32: wbmp132.exe wbmp232.exe wbmp332.exe wbmp432.exe

wbmp132.exe: main1.obw bitmap1.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbmp132 F main1.obw,bitmap1.obw$(W32_OBJS) L $(W32_LIBS)

wbmp232.exe: main2.obw bitmap2.obw
    	$(W32_LINK) $(W32_LINK_OPTS) N wbmp232 F main2.obw,bitmap2.obw$(W32_OBJS) L $(W32_LIBS)

wbmp332.exe: main3.obw bitmap3.obw bitmap2.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbmp332 F main3.obw,bitmap3.obw,bitmap2.obw$(W32_OBJS) L $(W32_LIBS)

wbmp432.exe: main4.obw bitmap4.obw bitmap2.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbmp432 F main4.obw,bitmap4.obw,bitmap2.obw$(W32_OBJS) L $(W32_LIBS)

# ----- Windows 32 dll bit Attrtest Programs --------------------------------
win32dll: wbmp1d.exe wbmp2d.exe wbmp3d.exe wbmp4d.exe

wbmp1d.exe: main1.obi bitmap1.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbmp1d F main1.obi,bitmap1.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wbmp2d.exe: main2.obi bitmap2.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbmp2d F main2.obi,bitmap2.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wbmp3d.exe: main3.obi bitmap3.obi bitmap2.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbmp3d F main3.obi,bitmap3.obi,bitmap2.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

wbmp4d.exe: main4.obi bitmap4.obi bitmap2.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbmp4d F main4.obi,bitmap4.obi,bitmap2.obi$(W32_DLL_OBJS) L $(W32_DLL_IMPORT_LIBS)

# ----- OS/2 Attrtest Programs ----------------------------------------------
# This is pending.

# ----- QNX Motif Attrtest Programs -----------------------------------------
qnx: attr1

attr1: mbmp1 mbmp2 mbmp3 mbmp4

mbmp1: main1.o bitmap1.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ main1.o bitmap1.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mbmp2: main2.o bitmap2.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ main2.o bitmap2.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mbmp3: main3.o bitmap3.o bitmap2.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ main3.o bitmap3.o bitmap2.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mbmp4: main4.o bitmap4.o bitmap2.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ main4.o bitmap4.o bitmap2.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mbnum mbutton mcombo mdate mdisplay mfstr mgmgmt mgroup mhlist micon
	rm -f minteger mntbk mprgrs mprompt mreal msclwin mscroll mspin mstatus
	rm -f mstring mtable mtbar mtext mtime mtree mtritm mutime mvlist
