## ----- Install options -----
CC = CC
LINK = CC
CC_FLAGS =
LINK_FLAGS =
CPP_EXTENSION = .cpp
INCLUDE_DIRS =
LIB_DIRS = -L/usr/lib/Motif1.2 -L/usr/lib/X11R5
GUI_LIBS = -lXm -lXt -lX11
LIBS = -lm

## ----- General options -----
ZAF_INC_DIR = ../../include
ZAF_LIB_DIR = ../../lib
Z_INCLUDE_DIRS = -I. -I$(ZAF_INC_DIR) $(INCLUDE_DIRS)
Z_LIB_DIRS = -L$(ZAF_LIB_DIR) $(LIB_DIRS)
Z_LIBS = -lZafMtfP -lZafMtf $(GUI_LIBS) $(LIBS)

.SUFFIXES:
.SUFFIXES: .o $(CPP_EXTENSION)

$(CPP_EXTENSION).o:
	$(CC) $(CC_FLAGS) $(Z_INCLUDE_DIRS) -c $<

posix: mbmp1 mbmp2 mbmp3 mbmp4

clean:
	-rm -f *.o core mbmp1 mbmp2 mbmp3 mmp4

mbmp1: main1.o bitmap1.o
	$(LINK) $(LINK_FLAGS) -o $@ main1.o bitmap1.o $(Z_LIB_DIRS) $(Z_LIBS)

mbmp2: main2.o bitmap2.o
	$(LINK) $(LINK_FLAGS) -o $@ main2.o bitmap2.o $(Z_LIB_DIRS) $(Z_LIBS)

mbmp3: main3.o bitmap3.o bitmap2.o
	$(LINK) $(LINK_FLAGS) -o $@ main3.o bitmap3.o bitmap2.o $(Z_LIB_DIRS) $(Z_LIBS)

mbmp4: main4.o bitmap4.o bitmap2.o
	$(LINK) $(LINK_FLAGS) -o $@ main4.o bitmap4.o bitmap2.o $(Z_LIB_DIRS) $(Z_LIBS)


