# Zinc Application Framework - MICROSFT.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

# ===========================================================================
# Usage

usage:
	@type <<

Usage:

nmake -f microsft.mak win32      (32 bit Windows)
nmake -f microsft.mak win32dll   (32 bit Windows dll's)
<<


# ===========================================================================
# Build dependencies

clean:
	z_clean

win32: wbmp132 wbmp232 wbmp332 wbmp432

win32dll: wbmp1 wbmp2 wbmp3 wbmp4


# ===========================================================================
# Build options for each target

# Shared options
ZAF_ROOT=..\..
PERSISTENCE=all
DEBUG=off

# Target-specific options
!if "$(TARGET)" == "wbmp132.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main1.cpp bitmap1.cpp

!elseif "$(TARGET)" == "wbmp232.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main2.cpp bitmap2.cpp

!elseif "$(TARGET)" == "wbmp332.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main3.cpp bitmap3.cpp bitmap2.cpp

!elseif "$(TARGET)" == "wbmp432.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main4.cpp bitmap4.cpp bitmap2.cpp

!elseif "$(TARGET)" == "wbmp1.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main1.cpp bitmap1.cpp

!elseif "$(TARGET)" == "wbmp2.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main2.cpp bitmap2.cpp

!elseif "$(TARGET)" == "wbmp3.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main3.cpp bitmap3.cpp bitmap2.cpp

!elseif "$(TARGET)" == "wbmp4.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main4.cpp bitmap4.cpp bitmap2.cpp
!endif

# ===========================================================================
# Continue build, or define options

!ifdef TARGET
# When options defined, build using ZAF 5 make files for Microsoft
!include "$(ZAF_ROOT)\include\zafmsc.mak"

!else
# Define options (macros) based on command-line platform

wbmp132 wbmp232 wbmp332 wbmp432 \
wbmp1 wbmp2 wbmp3 wbmp4:
	@ECHO .
	@ECHO .
	@ECHO Making $*.exe...
	@$(MAKE) -f microsft.mak TARGET=$*.exe $*.exe

!endif
