#include <zaf.hpp>
#include <z_prst.hpp>
#include "bitmap2.hpp"
#include "bitmap3.hpp"

// Start the application.
ZafApplication::Main()
{
	// This is for compilers that do not look in the library for main.
	LinkMain();

	// Create a storage pointer to the data file.
	ZafStorage *storage = new ZafStorage(ZAF_ITEXT("bitmaps.znc"), ZAF_FILE_READWRITE);

	// Check to see if the default storage was allocated.
	if (storage->Error())
		delete storage;

	// Create a pointer to the persistence.
	zafDataPersistence = new ZafDataPersistence(storage, zafDefaultDataConstructor);

	// Create the window and add the support objects.
	ZafWindow *window = new ZafWindow(0, 0, 25, 4);
	window->AddGenericObjects(new ZafStringData("Bitmap Window 3"));

	// Add the animated bitmap object to the window.
	*window + new AnimatedBitmap(1, 1, 0, 0, ZAF_ITEXT("WORLD_"), 15, 50);

	// Center the window and it to the window manager.
	zafWindowManager->Center(window);
	*zafWindowManager + window;

	// Process user responses.
	Control();

	// Cleanup
	delete zafDataPersistence;
	delete storage;

	// End the program.
	return(0);
}
