#include <zaf.hpp>
#include <z_prst.hpp>
#include "bitmap1.hpp"

// Start the main application.
ZafApplication::Main()
{
	// This is needed for some compilers that do not look in the library for main.
	LinkMain();

	// Create a pointer to the storage file.
	ZafStorage *storage = new ZafStorage(ZAF_ITEXT("bitmaps.znc"), ZAF_FILE_READWRITE);

	// Check to see if the default storage was allocated.
	if (storage->Error())
	{
		delete storage;
		return(-1);
	}

	// Create a pointer the persistence.
	zafDataPersistence = new ZafDataPersistence(storage, zafDefaultDataConstructor);

	// Create the window and add the support objects.
	ZafWindow *window = new ZafWindow(0, 0, 25, 4);
	window->AddGenericObjects(new ZafStringData("Bitmap Window 1"));

	// Add the bitmap object to the window.
	*window + new ZafBitmap;

	// Center the window on the screen before adding it to the window manager.
	zafWindowManager->Center(window);

	// Add the window to the window manager.
	*zafWindowManager + window;

	// Process user responses.
	Control();

	// Cleanup
	delete zafDataPersistence;
	delete storage;

	// End the program
	return(0);
}

