# Zinc Application Framework - BORLAND.MAK
# COPYRIGHT (C) 1990-1997.  All Rights Reserved.
# Zinc Software Incorporated.  Pleasant Grove, Utah  USA

# ===========================================================================
# Usage

usage:
	@type &&|

Usage:

make -f borland.mak win16      (16 bit Windows)
make -f borland.mak win32      (32 bit Windows)
make -f borland.mak win32dll   (32 bit Windows dll's)
|


# ===========================================================================
# Build dependencies

clean:
	z_clean

win16: wbmp116 wbmp216 wbmp316 wbmp416

win32: wbmp132 wbmp232 wbmp332 wbmp432

win32dll: wbmp1d wbmp2d wbmp3d wbmp4d


# ===========================================================================
# Build options for each target

# Shared options
ZAF_ROOT=..\..
PERSISTENCE=all
DEBUG=off

# Target-specific options
!if "$(TARGET)" == "wbmp116.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=main1.cpp bitmap1.cpp
DEFINITION_FILE=win16.def

!elif "$(TARGET)" == "wbmp216.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=main2.cpp bitmap2.cpp
DEFINITION_FILE=win16.def

!elif "$(TARGET)" == "wbmp316.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=main3.cpp bitmap3.cpp bitmap2.cpp
DEFINITION_FILE=win16.def

!elif "$(TARGET)" == "wbmp416.exe"
TARGET_TYPE=EXE
PLATFORM=WIN16
SOURCE_FILES=main4.cpp bitmap4.cpp bitmap2.cpp
DEFINITION_FILE=win16.def

!elif "$(TARGET)" == "wbmp132.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main2.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp232.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main2.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp332.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main3.cpp bitmap3.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp432.exe"
TARGET_TYPE=EXE
PLATFORM=WIN32
SOURCE_FILES=main4.cpp bitmap4.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp1d.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main1.cpp bitmap1.cpp

!elif "$(TARGET)" == "wbmp2d.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main2.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp3d.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main3.cpp bitmap3.cpp bitmap2.cpp

!elif "$(TARGET)" == "wbmp4d.exe"
TARGET_TYPE=EXEDLL
PLATFORM=WIN32
SOURCE_FILES=main4.cpp bitmap4.cpp bitmap2.cpp
!endif

# ===========================================================================
# Continue build, or define options

!ifdef TARGET
# When options defined, build using ZAF 5 make files for Borland
!include "$(ZAF_ROOT)\include\zafbor.mak"

!else
# Define options (macros) based on command-line platform

wbmp116 wbmp216 wbmp316 wbmp416 \
wbmp132 wbmp232 wbmp332 wbmp432 \
wbmp1d wbmp2d wbmp3d wbmp4d:
	@ECHO .
	@ECHO .
	@ECHO Making $<.exe...
	@$(MAKE) -f borland.mak TARGET=$<.exe $<.exe

!endif
