class ZafAnimatedBitmap : public ZafBitmap
{
public:
	// --- General members ---
	ZafAnimatedBitmap(int left, int top, int width, int height,
		ZafIChar *bitmapSeriesName, int numberOfBitmaps, int timerInterval = 250);
	~ZafAnimatedBitmap();
	virtual ZafEventType Event(const ZafEventStruct &event);

	// set
	virtual bool SetAnimated(bool animated);
	virtual void SetBitmapData();
	virtual void SetBitmapIndex(int bitmapIndex);
	virtual void SetNumberOfBitmaps(int numberOfBitmaps);
	virtual void SetBitmapSeriesName(ZafIChar *bitmapSeriesName);
	virtual void SetTimerInterval(int interval);

	// get
	virtual bool Animated() { return animated; }
	virtual int BitmapIndex() { return bitmapIndex; }
	virtual ZafIChar *BitmapSeriesName() { return bitmapSeriesName; }
	virtual int NumberOfBitmaps() { return numberOfBitmaps; }
	virtual int TimerInterval() { return timerInterval; }

protected:
	ZafTimer *bitmapTimer;
	ZafIChar *bitmapSeriesName;
	int bitmapIndex;
	int numberOfBitmaps;
	int timerInterval;
	bool animated;
};
