// COPYRIGHT (C) 1990-1997.  All Rights Reserved.
// Zinc Software Incorporated.  Pleasant Grove, Utah  USA
// May be freely copied, used and distributed.

#include <zaf.hpp>
#include <stdio.h>
#include "bitmap2.hpp"
#include "bitmap3.hpp"

// Constructor for the animated bitmap.
AnimatedBitmap::AnimatedBitmap(int left, int top, int width, int height,
	ZafIChar *_bitmapSeriesName, int _numberOfBitmaps, int _timerInterval) :
	ZafBitmap(left, top, width, height, ZAF_NULLP(ZafIChar)),
	numberOfBitmaps(_numberOfBitmaps), timerInterval(_timerInterval),
	currentBitmap(0)
{
	// Set the series name and the initial bitmap.
	bitmapSeriesName = strdup(_bitmapSeriesName);
	SetBitmapName("WORLD_0");

	// Create the timer which is used to do the animation.
	bitmapTimer = new ZafTimer(D_ON, timerInterval);
	bitmapTimer->Add(this);
	*zafEventManager + bitmapTimer;

	// Set various other attributes.
	SetAutoSize(TRUE);
	SetOSDraw(FALSE);
	SetBordered(TRUE);
}

// Destructor for the animated bitmap, for cleanup of its own data.
AnimatedBitmap::~AnimatedBitmap()
{
	if (bitmapSeriesName)
		delete [] bitmapSeriesName;

	if (bitmapTimer)
	{
		*bitmapTimer - this;
		*zafEventManager - bitmapTimer;
		delete bitmapTimer;
	}
}

// All event handling for an object is handled in the Event function.
ZafEventType AnimatedBitmap::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// The N_TIMER increments the bitmap counter and sets the next bitmap.
	case N_TIMER:
		{
		// Change the bitmap.
		ZafIChar bitmapName[50];
		currentBitmap++;
		sprintf(bitmapName, ZAF_ITEXT("%s%i"), bitmapSeriesName, currentBitmap % numberOfBitmaps);
		if (currentBitmap >= numberOfBitmaps)
			currentBitmap = 0;

		SetBitmapName(bitmapName);
		RedisplayData();
		}
		break;

	// All other events are processed by the base class.
	default:
		ccode = ZafBitmap::Event(event);
	}
	return (ccode);
}
