// COPYRIGHT (C) 1990-1997.  All Rights Reserved.
// Zinc Software Incorporated.  Pleasant Grove, Utah  USA
// May be freely copied, used and distributed.

#include <zaf.hpp>
#include "bitmap2.hpp"

// Constructor for the ZafBitmap class.
ZafBitmap::ZafBitmap(int left, int top, int width, int height,
	ZafIChar *tBitmapName) :
	ZafWindowObject(left, top, width, height),
	bitmapData(ZAF_NULLP(ZafBitmapData)), bitmapName(ZAF_NULLP(ZafIChar)),
	borderWidth(0)
{
	// Set the various attributes.
	SetNoncurrent(TRUE);
	SetAutoSize(FALSE);
	SetBitmapName(tBitmapName);
	SetOSDraw(FALSE);
	SetBordered(TRUE);
	if (Bordered())
		borderWidth = ZAF_BORDER_WIDTH;
}

// Destructor for the ZafBitmap.  Cleans up its own allocates data.
ZafBitmap::~ZafBitmap()
{
	if (bitmapName)
		delete [] bitmapName;
}

// Draw function for the ZafBitmap object
ZafEventType ZafBitmap::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	ZafRegionStruct region = BeginDraw();

	// Draw the border if the attribute it set.
	if (Bordered())
		DrawBorder(region, ccode);

	// Display the bitmap itself.
	if (bitmapData)
		zafDisplay->Bitmap(region.left, region.top, *bitmapData);

	// Draw the focus rectangle.  Draws is the non-current is false.
	DrawFocus(region, ccode);

	EndDraw();
	return(TRUE);
}

// Event handling is done in the Event function.
ZafEventType ZafBitmap::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_COMPUTE_SIZE:
		// Adjust the size of the object in to the size of the
		// bitmap if the autosize is set to true.
		if (AutoSize())
		{
			int height = bitmapData->Height();
			int width = bitmapData->Width();
			zafRegion.bottom = zafRegion.top + height + (2 * borderWidth) - 1;
			zafRegion.right = zafRegion.left + width + (2 * borderWidth) - 1;
		}
		ccode = ZafWindowObject::Event(event);
		break;

	default:
		ccode = ZafWindowObject::Event(event);
	}
	return (ccode);
}

// Function to set the autosize, true or false.
bool ZafBitmap::SetAutoSize(bool tAutoSize)
{
	autoSize = tAutoSize;
	return (autoSize);
}

// Load and set a bitmap.
void ZafBitmap::SetBitmapName(ZafIChar *tBitmapName)
{
	if (bitmapName || tBitmapName)
	{
		delete bitmapName;
		bitmapName = strdup(tBitmapName);
		if (bitmapData)
			delete bitmapData;
		bitmapData = new ZafBitmapData(ZAF_ITEXT(bitmapName), *zafDataPersistence);
	}
	else
	{
		bitmapName = ZAF_NULLP(ZafIChar);
		bitmapData = ZAF_NULLP(ZafBitmapData);
	}
}
