// COPYRIGHT (C) 1990-1997.  All Rights Reserved.
// Zinc Software Incorporated.  Pleasant Grove, Utah  USA
// May be freely copied, used and distributed.

#include <zaf.hpp>
#include "bitmap1.hpp"

// Constructor for the ZafBitmap class
ZafBitmap::ZafBitmap() : ZafWindowObject(20, 15, 64, 64)
{
	// Initialize the first bitmap.
	bitmapData = new ZafBitmapData(ZAF_ITEXT("WORLD_6"), *zafDataPersistence);

	// Set the coordinate type and other attributes.
	SetCoordinateType(ZAF_PIXEL);
	SetOSDraw(FALSE);
	SetBordered(FALSE);
	SetNoncurrent(TRUE);
}

// The Draw function for the bitmap.
ZafEventType ZafBitmap::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	BeginDraw();

	zafDisplay->Bitmap(0, 0, *bitmapData);

	EndDraw();
	return(TRUE);
}
