/*************************************************************************
 *              (C) Copyright 1989-1995 Visual Solutions, Inc.           *
 *                      All Rights Reserved                              *
 * This software may not be used, copied or made available to anyone,    *
 * except in accordance with the license under which it is furnished.    *
 *************************************************************************/

#ifndef INC_VSUSER_H
#define INC_VSUSER_H

#if defined(WIN32) | defined(_WINNT_)
# ifndef EXPORT
#   define EXPORT32 __declspec(dllexport)
#   define EXPORT
# endif
# ifndef FAR
#   define FAR
# endif
# ifndef PASCAL
#   define PASCAL
# endif
#elif defined( WIN16 )
# ifndef EXPORT
#   define EXPORT _export
# endif
# ifndef EXPORT32
#   define EXPORT32
# endif
# ifndef FAR
#   define FAR _far
# endif
# ifndef PASCAL
#   define PASCAL _pascal
# endif
#else
# define EXPORT
# define EXPORT32
# define FAR
# define PASCAL
#endif

#if  !defined(_INC_WINDOWS) & !defined(_WINNT_) & !defined(__WINDOWS_H)
typedef unsigned HWND;
typedef unsigned WPARAM;
typedef long LPARAM;
typedef char FAR* LPSTR;
#endif

#define TRUE 1
#define FALSE 0

#ifndef NO_PROTOS
# define  P(s) s
#else
# define P(s) ()
#endif

#if defined(__TCPLUSPLUS__)  || defined(__cplusplus)
extern "C" {        /* Start C declarations for C++ */
#endif
typedef double FAR DOUBLE;
typedef void FAR *VOID_PTR;
typedef int FAR PASCAL USER_BLOCK();
typedef int FAR PASCAL USER_OPT_FUNC(DOUBLE *unknownVec, int unknownCount
    , int costCount, int globalConstraintCount);
typedef void FAR PASCAL USER_BLOCK_V();
typedef long FAR PASCAL USER_BLOCK_L();
typedef char FAR* FAR PASCAL USER_BLOCK_STR();
typedef USER_BLOCK *USER_BLOCK_FUNC;
typedef LPSTR PASCAL USER_EVENT_FUNC( HWND, int, WPARAM, LPARAM);

/* Return sim time thru arg pointer since not all langs agree
 * on how to return a double val */
EXPORT32 void PASCAL FAR EXPORT getSimTime( DOUBLE *pTime);
EXPORT32 void PASCAL FAR EXPORT getSimTimeStep( DOUBLE *pTimeStep);
EXPORT32 void PASCAL EXPORT stopSimulation( int stopVal); /* 1:stop this run,2:stop multirun */
EXPORT32 void PASCAL EXPORT setBlockErr();     /* Flag Block in Red */
EXPORT32 EXPORT debMsg P((char FAR *fmt , ... ));
EXPORT32 void FAR *PASCAL EXPORT galloc (unsigned long size );
EXPORT32 void PASCAL EXPORT gfree (void FAR *freeP );
EXPORT32 void FAR *PASCAL EXPORT grealloc (void FAR *inP , unsigned long size );
EXPORT32 int FAR PASCAL EXPORT userSolver();
EXPORT32 long EXPORT FAR PASCAL vsmRequest( long FAR*, double FAR*);
EXPORT32 long FAR EXPORT vissimRequest( long , LPARAM, LPARAM);

#if defined(__TCPLUSPLUS__)  || defined(__cplusplus)
 }        /* End C declarations for C++ */
#endif  /* CPLUSPLUS */

typedef struct {
  char FAR* menuName;
  char FAR* funcName;
  int inputCount;
  int outputCount;
  int paramCount;
  char FAR* helpText;
} USER_MENU_ITEM;

EXPORT32 void EXPORT setUserBlockMenu P((USER_MENU_ITEM FAR * ));

#define MAX_TITLE_LEN (180)
#define MAX_USER_NAME_LEN (80)

typedef struct {
  float VisSimVersion;
  double timeStart, timePanel, timeEnd, T;
  unsigned char fReadOnly:1, fDisplayPanel:1;
  char product;                 /* product type (demo, professional, etc.) */
  char continuousMode;          /* run simulation in continuous mode */
  char endNotify;               /* notify the user on end simulation w/beep and MessageBox */
} SIM_INFO;

typedef struct {
  double errEpsilon;
  int loopMax;
  unsigned iterationCount;
} OPT_INFO;

#ifndef WM_USER
#define WM_USER 0x400
#endif

typedef enum {PROD_UNKNOWN, PROD_RUNTIME, PROD_DEMO, PROD_MICRO,
                PROD_STUDENT, PROD_TRIAL, PROD_FULL} SIM_PRODUCT;

typedef enum {
  VR_NULL, VR_GET_CONSTRAINTS
  , VR_GET_UNKNOWNS, VR_SET_UNKNOWNS
  , VR_GET_SOLVER_INFO, VR_EXECUTE, VR_GET_UNKNOWNS_INPUT
  , VR_SET_BLOCK_MENU, VR_RESET_XFERS, VR_GET_VERSION
  , VR_GET_BLOCK_PARAMS, VR_SET_BLOCK_CONNECTOR_COUNT
  , VR_GET_GLOBAL_CONSTRAINTS, VR_GET_GLOBAL_CONSTRAINT_BOUNDS, VR_GET_GLOBAL_COST
  , VR_GET_GLOBAL_UNKNOWNS, VR_GET_GLOBAL_UNKNOWN_BOUNDS
  , VR_GET_GLOBAL_UNKNOWNS_INPUT, VR_SET_GLOBAL_UNKNOWNS
  , VR_RUN_SIMULATION, VR_GET_GLOBAL_OPT_INFO, VR_GET_VISSIM_STATE
} VR_CMD;

/* VisSim Simulation Event message, called once for each DLL */
typedef enum {
  VSE_NULL=WM_USER+3000, VSE_TIME_STEP, VSE_PRE_SIM_START, VSE_SIM_STOP 
} VSE_CMD;

/* Block event message, called once for each user block in a diagram */
#define WM_VSM_GET_PARAM_DESC   WM_USER+2000
#define WM_VSM_GET_BLOCK_NAME   WM_USER+2001
#define WM_VSM_WINDOW_HANDLE    WM_USER+2002
#define WM_VSM_ABORT_SIM        WM_USER+2003
#define WM_VSM_FILE_CLOSE       WM_USER+2004
#define WM_VSM_BLOCK_INFO       WM_USER+2005
#define WM_VSM_INFO             WM_USER+2006
#define WM_VSM_SNAP_STATE       WM_USER+2007
#define WM_VSM_CHECKPOINT_STATE WM_USER+2008
#define WM_VSM_FILE_READ        WM_USER+2009
#define WM_VSM_BLOCK_SETUP      WM_USER+2010
#define WM_VSM_ADD_CONNECTOR    WM_USER+2011
#define WM_VSM_DEL_CONNECTOR    WM_USER+2012
#define WM_VSM_CREATE           WM_USER+2013
#define WM_VSM_DESTROY          WM_USER+2014
#define WM_VSM_BLOCK_PLACED     WM_USER+2015

#endif
