/*************************************************************************
 *              (C) Copyright 1989-94 Visual Solutions                   *
 *                      All Rights Reserved                              *
 * This software may not be used, copied or made available to anyone,    *
 * except in accordance with the license under which it is furnished.    *
 *************************************************************************/

#ifndef CGEN_H
#define CGEN_H
#include <stdio.h>

#include "vsuser.h"

#define TRUE 1
#define FALSE 0
#define MAX_FN 32
#define MAX_DATA_POINT_COUNT 8192
#define UNIT_DELAY(n,b) ((b)&& unitDelay((int)n), delayOut[(int)n])
#define LATCH_UNIT_DELAY(n,b,v) if (b) latchUnitDelay( n, v)
#define SAMPLE_HOLD(b,v,n)  ((b)?(SHBuf[n] = (v)): SHBuf[n])
#define LIMIT(n,h,l)  if (n > h) n = h;else if (n < l) n = l
#define M(a,b,c) *matRef(a,b,c)
#if 0
#ifndef FAR
#define FAR
#define PASCAL
#define EXPORT
#else
#define FAR _far
#define PASCAL _pascal
#define EXPORT _export
#endif
#endif
typedef int INT;
typedef double CGDOUBLE;

#ifndef __MSC__         /* iaj define the typedef BITFIELD */
  /* ANSI spec for bitfields is int or unsigned int I believe */
  typedef unsigned int BITFIELD;
#else                           /* Microsoft C++ */
  typedef unsigned char BITFIELD;
#endif

typedef struct {
  long runCount;
  CGDOUBLE timeStart, timePanel, timeEnd, T;
  CGDOUBLE timeStep;
  BITFIELD SimStartUp:1, firstPass:1, lastPass:1, reevaluating:1, autoRestart:1, retainStates:1;
  char stopRequested;
} SIM_STATE;

extern SIM_STATE sim;
extern CGDOUBLE dataOutInterval;

typedef struct {
  CGDOUBLE minVal, maxVal, scaleFactor;
} BOUNDS;

typedef struct {
  CGDOUBLE high, low;
} INTEG_LIMIT;

#define MAX_PLOTS (4)
#define WAY_FAR 

typedef void (*SIM_FUNC)();

typedef struct {
  long maxSize;
  long curSize;
  CGDOUBLE WAY_FAR*dlist;
} DLIST;

#define MAX_NAME_LEN 32
#define MAX_PATH_LEN 128

typedef struct {
  DLIST data;
} DATA_SET;

#define MAX_DATA_SETS (16)
typedef struct {
  unsigned step;  /* Data points to skip */
  unsigned stepCount; /* Current intermediate calc */
  unsigned long dataPointCount;  /* Max data points */
} DATA_STEP;

typedef struct
{ 
  unsigned int isTemp:1;
  unsigned dim1;
  unsigned dim2;
  CGDOUBLE d[1];
}  MATRIX;

typedef struct {
  char *fileName;
  CGDOUBLE intervalStart;
  CGDOUBLE intervalStop;
  CGDOUBLE intervalStep;
  int itemCount;
  int precision;        /* # of digits of numeric precision to save */
  CGDOUBLE lastSampleTime;
  BITFIELD noWriteHeader:1;
  BITFIELD isMatrix:1;
  BITFIELD isBinary:1;
  BITFIELD hasTimeColumn:1;
  BITFIELD wantFlush:1;
  BITFIELD appendToFile:1;
  long flushInterval;
  long nextFlushTime;
  unsigned lastPointWritten;
  unsigned char timeColumn;
  unsigned char columnCount;
  long timeLastMod;
  unsigned pointCount;
  unsigned lastIndexX;
  unsigned lastIndexY;
  DATA_STEP ds;
  MATRIX *mat;
  DATA_SET dataSet[MAX_DATA_SETS];
  FILE *fh;                     /* open file handle */
} DATA_FILE_INFO;

typedef struct {
  char fileName[MAX_NAME_LEN];
  CGDOUBLE intervalStep;
  BITFIELD noWriteHeader:1;
} EXPORT_INFO;

typedef struct {
  unsigned bufSize;
  unsigned bufMax;
  CGDOUBLE *buf;
  CGDOUBLE lastTime;
  BITFIELD bufBeenRealloced:1,latchInput:1,saveLatch:1;
  CGDOUBLE delayTime;
  CGDOUBLE step;
  unsigned bufPtr, bufLen;
} TIME_DELAY_INFO;

typedef struct {
  int len;
  CGDOUBLE *vec;
} VECTOR;

typedef struct {
  BITFIELD isDiscrete:1;
  CGDOUBLE dT;
  CGDOUBLE gain;
  MATRIX *phi, *psi;
  MATRIX *c, *d;
  MATRIX *state;
  CGDOUBLE *u,*y;
  CGDOUBLE lastTime;
  MATRIX *deriv;
  MATRIX *lastState;
  CGDOUBLE lastResult;
} XFERFUN_INFO;

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#ifndef max
#define max(a,b) MAX(a,b)
#define min(a,b) MIN(a,b)
#endif

void limitIntegOutput(void);

/* Integration methods */
#define IDG_INTEG_EULER   170
#define IDG_INTEG_TRAP         171
#define IDG_INTEG_RUNGKUT_2    172
#define IDG_INTEG_RUNGKUT_4    173
#define IDG_INTEG_RUNGKUT_AS4   174
#define IDG_INTEG_BULSTOER      175
#define IDG_INTEG_STIFF_EULER   176

#include "math.h"
#include "cg.h"
#include "xfer.h"
#include "import.h"
#include "cgio.h"
#include "fileio.h"
#include "mat.h"
#include "rtdos.h"
#include "userdll.h"

#endif
