// version 1.3

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define MISSION1 0x21e  // offset from the end of the file

#define NAME_OFS 0x21a  // offset to first byte of name - used to check
												// whether its gdi or nod file

void SeekAddress();

long int ofs, m1, m2;
												
FILE *file;

void main(int argc, char *argv[])
{
	int newmis;
	char name;

	
	if (argc != 2)
	{
		printf("Usage : cced <savegame.???>\n");
		exit(0);
	}

	file = fopen(argv[1], "rb+");
	if (file == NULL)
	{
		printf("Could not open file - exiting\n");
		exit(0);
	}

	fseek(file, -NAME_OFS, SEEK_END);
	fread(&name, sizeof(name), 1, file);

	// this is the same for both cases
	fseek(file, -MISSION1, SEEK_END); // read in the current mission
	fread(&m1, sizeof(m1), 1, file);  // using negative offsets because
																		// we are starting from the end
																		// of the file.

	SeekAddress();

	if (ofs == MISSION1)
	{
		printf("Could not locate value to change. Back at original position.\n");
		printf("Please email me at: buggy@adam.com.au if you get this message.\n");
		printf("Try using this on a different file. Exiting.\n");
		fclose(file);
		exit(0);
	}
	
	clrscr();
	printf("Command and Conquer Misson Selector   written by buggy@adam.com.au\n");
	printf("Version 1.4\n\n");
	printf("Editing file: %s\n\n", argv[1]);	
	if (name == 'G')
		printf("GDI savegame file\n");
	else if (name == 'N')
		printf("NOD savegame file\n");
	printf("Current mission: %d\n", m1); // show what the current mission is

	printf("Enter new mission (-1 to exit with no change): ");
	scanf("%i", &newmis);

	if (name == 'G')
	{	// 15 possible mission for nod
		if (newmis > 0 && newmis < 16)
		{       // write to the file and exit
			fseek(file, -MISSION1, SEEK_END);
			fwrite(&newmis, sizeof(newmis), 1, file);
			fseek(file, -ofs, SEEK_END);
			fwrite(&newmis, sizeof(newmis), 1, file);
			printf("Changes written to file.\n");
			printf("Remember: load the mission, then abort->restart it to use new mission\n");
		}
		else
			printf("No changes made to the file.\n");
	}
	else if (name == 'N')
	{
		if (newmis > 0 && newmis < 14)
		{
			fseek(file, -MISSION1, SEEK_END);
			fwrite(&newmis, sizeof(newmis), 1, file);
			fseek(file, -ofs, SEEK_END);
			fwrite(&newmis, sizeof(newmis), 1, file);
			printf("Changes written to file.\n");
			printf("Remember: load the mission, then abort->restart it to use new mission\n");
		}
		else
			printf("No changes made to the file.\n");
	}
	
	fclose(file);

}


void SeekAddress()
{
	long int i;
	char cont;

	cont = 1;
	
	i = MISSION1 + 1;

	// look backwards for 0x1d
	while (cont)
	{
		if (i > 0x320)		// a large number never reached, make sure it doesn't
		{									// loop forever
			printf("Could not locate start value. Failed to initialise offset\n");
			printf("for editing.\n");
			fclose(file);
			exit(0);
		}
		fseek(file, -i, SEEK_END);
		fread(&m2, sizeof(m2), 1, file);
		if (m2 == 0x1d) cont = 0;
		else ++i;
	}

	cont = 1;

	// skip a little bit (for the sake of the first mission with 0x01 as mission number
	// now count backwards
	i -= 11;
	
	while (cont)
	{
		if (i == MISSION1)	// back to starting position
			cont = 0;
		fseek(file, -i, SEEK_END);
		fread(&m2, sizeof(m2), 1, file);
		if(m2 == m1)
		{	// only reach here if we found the variable
			ofs = i;
			cont = 0;
		}
		else --i;
	}
}
