#######################################################
#						      #
#    dtM.tcl -- dtM's custom tcl script for XiRCON    #
#						      #
#######################################################

# set this to 1 if you want to use query windows, 0 if not
set wantquery 0
# set this to the channels you want to autojoin, seperated by a space
set autochans "#descent #eggdrop #primenet #xircon"
set script "dtM.tcl v1.0b by dtM"

on CTCP {	
	set x [string index [args] 0]
        switch -glob [string toupper [lindex [args] 1]] {
	"VER*" {
	    if {$x == "&" || $x == "#"} {
	    /raw notice [nick] :VERSION XiRCON Communicator 1.0B1 + $script\
	    echo "[color ctcp]*** [color nick][nick][color ctcp] versioned everyone on [channel]" status
	    complete
	    } {
	    /raw notice [nick] :VERSION XiRCON Communicator 1.0B1 + $script\
	    echo "[color ctcp]*** [color nick][nick][color ctcp] requested your version" status
	    complete
	    }
	}
    }
}

on CONNECT {
	foreach aj $autochans {
		/join $aj
	}
}

on JOIN {
	if {[nick]==[my_nick]} {
	echo "[color join]::: [my_nick] ([my_user]@[my_host]) has joined [args]" channel [args]
	complete
	} {
	echo "[color join]::: [nick] ([user]@[host]) has joined [args]" channel [args]
	complete
	}
}

on PART {
	echo "[color part]::: [nick] ([user]@[host]) has left [args]" channel [args]
	complete
}

set queryNicks ""
set isdoingqwhois 0

on PRIVMSG {
	set text [join [lrange [args] 1 end]]
	set dest [string tolower [lindex [args] 0]]
	set x [string index $dest 0]
	if {$x == "&" || $x == "#"} {
		if {[string first [string tolower [my_nick]] [string tolower $text]] >= 0} {
			echo "[color nick][color ctcp][nick][color nick]?[color public] $text" channel $dest
			complete
		} {
			echo "[color nick]\[[color public][nick][color nick]\][color public] $text" channel $dest
			complete
		}
	} {
		if {$wantquery == 1} {
			set dest [string tolower [lindex [args] 0]]
			if {$dest == [string tolower [my_nick]]} {
				set qnick [string tolower [nick]]
				foreach q [queries] {
					if {$nick == [string tolower $q]} {return}
				}
			}
			lappend queryNicks $nick
			whois $qnick
			global isdoingqwhois
			set isdoingqwhois 1
			complete
		} {
			echo "[color ctcp]\[[nick][color ctcp]\([user][color ctcp]@[host][color ctcp]\)[color ctcp]\][color public] $text" [window_type] [window_name]
			complete
		}
	}
}

alias K {/kick [args]
	 complete
}
 
alias ver {
	/ctcp [args] VERSION
	complete
}

alias sv {
	say "Running XiRCON Communicator 1.0B1 + $script"
	complete
}

alias PRIVMSG {
	set text [join [lrange [args] 1 end]]
	set dest [string tolower [lindex [args] 0]]
	set x [string index $dest 0]
	if {$x == "#" || $x == "&"} {
		/raw PRIVMSG $dest :$text
		echo "[color ctcp]\[[color public][my_nick][color ctcp]\][color public] $text" channel $dest
		complete
	} {
		/raw PRIVMSG $dest :$text
		echo "-> *[color nick]$dest[color public]* $text" [window_type] [window_name]
		complete
	}
}

alias MSG {
	if {[llength [args]] > 0 && [llength [lindex [args] 2]] > 0} {
		/privmsg [args]
		complete
	}
}

alias AME {
    foreach c [channels] {
        /ctcp $c ACTION [arg]
        echo "[color nick]* [my_nick][color public] [arg]" channel $c
    }
    complete
}

alias GONE {
	/ame is away: [join [lrange [args] 0 end]]
	/raw away :[join [lrange [args] 0 end]]
	complete
}

alias back {
	/ame is back!
	/raw away
	complete
}

on 319 {
	if {$isdoingqwhois} {
		set idx [lsearch $queryNicks [string tolower [lindex [args] 1]]]
		if {$idx > -1} {
			set queryNicks [lreplace $queryNicks $idx $idx]
			echo "[lindex [args] 1] is in channels: [lindex [args] 2]" query [lindex [args] 1]
		}
		set isdoingqwhois 0
		complete
	} {
		echo "[color ctcp]\[chans\][color public] on channels: [join [lrange [args] 2 end]]" [window_type] [window_name]
	}
}

on 312 {
	echo "[color ctcp]\[server\][color public] on IRC via [lindex [args] 2] \([join [lrange [args] 3 end]]\)" [window_type] [window_name]
}

on 313 {
	echo "[color ctcp]\[oper\][color public] [lindex [args] 1] is an iRC Operator" [window_type] [window_name]
}

on 317 {
	echo "[color ctcp]\[idle\][color public] idle [lindex [args] 2] seconds" [window_type] [window_name]
}

on 311 {
	echo "[color ctcp]\[whois\][color public] [lindex [args] 1] \([lindex [args] 2]@[lindex [args] 3]\) \[[join [lrange [args] 5 end]]\]" [window_type] [window_name]
}

on 301 {
	echo "[color ctcp]\[away\][color public] [lindex [args] 1] is away: [join [lrange [args] 2 end]]" [window_type] [window_name]
}

global nonick
set nonick 0

on 401 {
	set nonick 1
}

#on 318 {
#	if {$nonick != 1} {
#	echo "15*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*115*5*4*1" [window_type] [window_name]
#	}
#}

alias WI {
	/whois [args]
	complete
}

alias WII {
	/whois [lindex [args] 0] [lindex [args] 0]
	complete
}

alias tcl {eval [join [args]];complete}
