######################################################################################
############################  User Management Procedures  ############################
######################################################################################

set lookupNick(Global) 1
set justLookup 0

alias useradd {
	set nick [lindex [args] 0]
	set group [lindex [args] 1]
	if {[addUser $nick 2 $group]} {
		echo "*** $nick successfully added as a new user"
	} else {
		echo "*** User $nick already exists"
	}		
}

alias userdel {
	set nick [lindex [args] 0]
	set group [lindex [args] 1]
	if {[delUser $nick $group]} {
		echo "*** $nick successfully deleted"
	} else {
		echo "*** User $nick does not exists"
	}		
}


alias ua {
	set user [lindex [args] 0] 
	set type [lindex [args] 1]
	set group [lindex [args] 2]
	addUser $user $type $group
}  

alias getmask {
	set nick [lindex [args] 0] 
	set type [lindex [args] 1]
	set justLookup 1
	set lookupNick([string tolower $nick]) [list $type ""]
	whois $nick
}

proc getNick {userString} {
	set bangIdx [string first "!" $userString]
	if {$bangIdx > 0} {
		set nick [string range $userString 0 [expr $bangIdx - 1]]
	} else {
		set nick $userString
	}
	return $nick
} 

proc getHostMask {userString} {
	set bangIdx [string first "!" $userString]
	if {$bangIdx > 0} {
		set hostmask [string range $userString [expr $bangIdx + 1] end]
	} else {
		set hostmask ""
	}
	return $hostmask
}

proc findUser {user group} {
	set hostmask [getHostMask $user]
	set rVal -1
	forEachUser idx muser grp {
		if {$hostmask == ""} {
			set match	[string match [string tolower "${user}*"] [string tolower $muser]]
		} else {
			set match	[string match [string tolower $user] [string tolower $muser]]
  	}
		if {$match && "$group" == "$grp" } {set rVal $idx; break}
	} 
	return $rVal
}
                              
proc addUser {nick type group} {
	global lookupNick
	set idx [findUser $nick $group]
	if {$idx > -1} {
		set muser [lindex [get_user $idx] 0]
		return 0
	}
	set hostmask [getHostMask $nick]
	if {$hostmask != "" || $type == 0} {
		add_user $nick $group
		return 1
	} 
	set lookupNick([string tolower $nick]) [list $type $group]
	whois $nick
	return 1
}

proc delUser {nick group} {
	set idx [findUser $nick $group]
	if {$idx > -1} {
		del_user $idx
		return 1
	} else { 
		return 0
	}
}
 
proc copyUser {fromNick fromGroup toNick toGroup} {
	set fromIdx [findUser $fromNick $fromGroup]
	set toIdx [findUser $toNick $toGroup]
	if {$fromIdx < 0} {  
		return 0
	}
	if {$toIdx < 0} {
		add_user $toNick $toGroup
	}
	foreach prop [enum_user_props] {
		set_user_prop $toIdx $prop [get_user_prop $fromIdx $prop]
	}
}

on WHOIS {
	set lnick [string tolower [nick]]
	set l [getArrayValue lookupNick $lnick] 
	set type [lindex $l 0]
	set group [lindex $l 1]
	if {$type > -1 && !$justLookup} {
		set lookupNick($lnick) -1                     
		set mask [getHostType $type [nick] [user] [host]]
		add_user $mask $group
	}
	if {$type > -1 && $justLookup} {
		set lookupNick($lnick) -1                     
		set mask [getHostType $type [nick] [user] [host]]
		echo "*** Hostmask for [nick]: Type = $type  **  Mask = $mask"
	}		
}
 

		