set isTopicLocked(foo) ""
set lockedTopic(foo) ""

alias lt {
	set chan [lindex [args] 0] 
	set topic [expr {[string match "#*" "$chan"] ? [lrange [args] 1 end] : [args]}]
	set chan [expr {[string match "#*" "$chan"] ? $chan : [channel]}]
	set isTopicLocked($chan) 1
	if {$topic != ""} {
		/raw topic $chan :$topic
		/raw topic $chan
	} else {
		/raw topic $chan
	}
	/raw notice $chan :Be Irie M0n: Topic in $chan is now locked
	echo "Topic locked in $chan"
	complete
}

alias ut {
	set chan [lindex [args] 0] 
	set chan [expr {$chan == "" ? [channel] : $chan}]
	set isTopicLocked($chan) 0 
	/raw notice $chan :Be Irie M0n: Topic in $chan is no longer locked  
	echo "Unlocked topic in $chan"
	complete
}

 
on TOPIC {
	set channel [lindex [args] 0]
	set topic [lindex [args] 1]
	if {[nick] != [my_nick] && [getArrayValue isTopicLocked $channel] > 0} {
		/raw topic $channel :$lockedTopic($channel)
		/raw NOTICE [nick] :Be Irie M0n: Dis Topic be locked by [my_nick]
	} elseif {[nick] == [my_nick] && [getArrayValue isTopicLocked $channel] > 0} {
		set lockedTopic($channel) $topic
	} 
}

on 331 {
	set channel [lindex [args] 1]
	if {[getArrayValue isTopicLocked $channel] > 0} {
		set lockedTopic($channel) "" 
		complete
  }
}

on 332 {
	set channel [lindex [args] 1] 
	if {[getArrayValue isTopicLocked $channel] > 0} {
		set lockedTopic($channel) [lindex [args] 2]
		complete
	}
}

on 333 {
	set channel [lindex [args] 1] 
	if {[getArrayValue isTopicLocked $channel] > 0} {
		complete
	}
}


# Just formatting the /topic command a little better

set irieTopic ""

on 332 {
    set irieTopic [lindex [args] 2]
    complete		
}

on 333 {
    echo "\afa*** Topic \"${irieTopic}\" set by [lindex [args] 2] on [clock format [lindex [args] 3] -format "%a %I:%M:%S %p %Z"]" 
    complete              
}
