set completionList ""
set completionIdx 0
set lastPartial ""
set lastMatch ""

hotkey tab {
    set a ""
    set b ""
    set c ""
    set text [input get_text]
    set start [input get_sel_start]
    set length [input get_sel_length]
    regexp -nocase {(.* +)?([^ ]+ *$)} $text a b c
    set c [string trim $c]
    set c [string trim $c :]
    set b [string trim $b]
    if {$c == $lastMatch} {
	set output [nickcomplete $lastPartial 1]
    } else {
	set output [nickcomplete $c 0]
    }
    
    if {$output == ""} {complete;return}
    
    if {$b == ""} {
		set output "$output: "
    } else {
	set output "${b} $output "
    }
    
    input set_text $output
    input set_sel_start [string length $output]
    input set_sel_length $length
    complete
}

proc nickcomplete {partial {repeatLast 0}} {
    global completionList
    global completionIdx
    global lastPartial
    global lastMatch
    set cl [resetCompletionList]
    if {$repeatLast} {
	incr completionIdx
	if {$completionIdx >= [llength $cl]} {
	    set completionIdx 0
	}
	set cl [lrange $cl $completionIdx end]
		set partial $lastPartial
    } else {
	set completionIdx 0
    }
    
    
    set lastPartial $partial
    
    set idx [ilsearch $cl "${partial}*"]
    set completionIdx [expr $completionIdx + $idx]
    
    if {$idx == -1} {
	set completionIdx 0
	set cl [resetCompletionList]
	set idx [ilsearch $cl "${partial}*"]
	set completionIdx [expr $completionIdx + $idx]
    }
    
    set lastMatch [lindex $cl $idx]
    return $lastMatch
}

proc resetCompletionList {} {
    global completionList
    set cl $completionList
    if {[window_type] == "channel"} {
	foreach nick [nicks [channel]] {
	    set n [string trimleft $nick "@+"]
	    lappend cl $n
	}
    }
    return $cl
}

alias PRIVMSG {
    set nick [lindex [args] 0]
    if {$nick != [channel]} {
	iremoveFromList completionList $nick
	set completionList [linsert $completionList 0 $nick]
    }
}

on privmsg {
    if {[sCompare [lindex [args] 0] [my_nick]]} {
	set nick [lindex [args] 0]
	iremoveFromList completionList $nick
	set completionList [linsert $completionList 0 $nick]
    }
}

