######################################################################################
###################  Procedures for a Hostmask sensitive NOTIFY  #####################
######################################################################################

## GLOBALS ##

#all nicks in notifyArray that are currently online
set nicksNowOn ""
#all nicks in notifyArray that are online, with the correct hostmask
set peopleNowOn ""
set notifyTimer 0

## Procedures ##


#Shows the current values in the notify array
alias showNotifies {
	for {set i 0} {$i < [user_count]} {set i [expr $i + 1]} {
		if { [get_user_prop $i notify_flag] == "1" } {
			set entry [get_user $i]
			set nick [lindex $entry 0]
			set masks [get_user_prop $i notify_hostmasks]
			echo "Index: $i   Nick: $nick   HostMasks: $masks"
		}
	}
}

alias addNotify {
	addNotify [lindex [args] 0] [lrange [args] 1 end]
}

proc addNotify {nick mask} {
	set idx [find_user $nick]
	if {$idx < 0} {
		add_user $nick
		set idx [find_user $nick]
	}
	set hostmasks [get_user_prop $idx notify_hostmasks]  
   if {![isInList $hostmasks $mask]} {
		lappend hostmasks $mask
		echo "*** Added $nick with hostmask $mask to Notify list"
	}
	set_user_prop $idx notify_hostmasks $hostmasks
} 

alias delNotify {
	delNotify [lindex [args] 0] [lrange [args] 1 end]
}

proc delNotify {nick mask} {
	set idx [find_user $nick]
	if {$idx < 0} {
		echo "*** Error: User $nick does not exist ***"
		return
	}
	set hostmasks [get_user_prop $idx notify_hostmasks]  
	removeFromList hostmasks $mask
	set_user_prop $idx notify_hostmasks $hostmasks
}

proc toggleNotify {nick} {
	set idx [find_user $nick]
	if {$idx > -1} {
		set notify [get_user_prop $idx notify_flag]
		if {$notify == ""} {set notify 0}
		set_user_prop $idx notify_flag [expr ! $notify]
	}
}

alias notify {
	set notifyList ""
	set nick [lindex [args] 0]
	if {$nick != ""} {
		set idx [find_user $nick]
		if {$idx < 0} {
			addNotify $nick *@*.*
		} elseif {[get_user_prop $idx notify_hostmasks] == ""} {
			set_user_prop $idx notify_hostmasks *@*.*
		}
		toggleNotify $nick
	} 
	for {set i 0} {$i < [user_count]} {set i [expr $i + 1]} {
		if { [get_user_prop $i notify_flag] == "1" } {
			set entry [get_user $i]
			set nick [lindex $entry 0]
			lappend notifyList $nick
		}
	}
  if {$notifyList != ""} {/raw ISON $notifyList}
	foreach person $peopleNowOn {
		echo "*** $person is on IRC ***"
	}       
}
 

#Server reply for ISON (Notify)
on 303 {
	set isonList [stringListToLower [lindex [args] 1]]
	#echo "ISON: nicks: $nicksNowOn * people: $peopleNowOn * ison: $isonList"
	foreach nick $isonList {
		set nick [string tolower $nick]
		if {![isInList $nicksNowOn $nick]} {
			whois $nick
			lappend nicksNowOn $nick
		}
	}
	set newList ""
	foreach nick $nicksNowOn {
		if {[isInList $isonList $nick]} {
			lappend newList $nick
		}
	}
	set nicksNowOn $newList
	foreach person $peopleNowOn {
		if {![isInList $nicksNowOn $person]} {
			set i [lsearch $peopleNowOn $person]
			set peopleNowOn [lreplace $peopleNowOn $i $i]
			secho "*** $person has left IRC ***"
		}
	}
	complete
}

on WHOIS {
	#echo "WHOIS: nicks: $nicksNowOn * people: $peopleNowOn"	
	set nick [string tolower [nick]]
	set nickhost [string tolower [string trimleft [user] "~"]@[host]]
	if {[isInList $nicksNowOn $nick]} {
		set hostmasks [get_user_prop [find_user $nick] notify_hostmasks]
		foreach hostmask $hostmasks {
			set hostmask [string tolower $hostmask]
			if {[string match $hostmask $nickhost]} {
				if {![isInList $peopleNowOn $nick]} {
					lappend peopleNowOn $nick
					secho "*** $nick with host $nickhost is now on IRC ***"
					break
				}
			}
		}
	}
	#echo "WHOIS: nicks: $nicksNowOn * people: $peopleNowOn"
}

on TIMER {
	if {$CONNECTED} {
		set notifyTimer [expr $notifyTimer + 1]
		if {[expr $notifyTimer % 15] == 0} {
			set notifyList ""
			for {set i 0} {$i < [user_count]} {set i [expr $i + 1]} {
				if { [get_user_prop $i notify_flag] == "1" } {
					set entry [get_user $i]
					set nick [lindex $entry 0]
					lappend notifyList $nick
				}
			}
			if {$notifyList != ""} {/raw ISON $notifyList}
		}
	}
}


